/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Iterator;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.net.ConnProcessorExceptionEvent;
import net.kano.joscar.net.ConnProcessorExceptionHandler;

public abstract class ConnProcessor {
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar.net");
    private boolean attached = false;
    private InputStream in = null;
    private OutputStream out = null;
    private final CopyOnWriteArrayList<ConnProcessorExceptionHandler> errorHandlers = new CopyOnWriteArrayList();

    public final synchronized void attachToSocket(Socket socket) throws IOException {
        DefensiveTools.checkNull(socket, "socket");
        this.attachToInput(socket.getInputStream());
        this.attachToOutput(socket.getOutputStream());
    }

    public final synchronized void attachToInput(InputStream inputStream) {
        DefensiveTools.checkNull(inputStream, "in");
        this.in = inputStream;
        this.attached = true;
    }

    public final synchronized void attachToOutput(OutputStream outputStream) {
        DefensiveTools.checkNull(outputStream, "out");
        this.out = outputStream;
        this.attached = true;
    }

    protected final synchronized boolean isAttached() {
        return this.attached;
    }

    protected final synchronized InputStream getInputStream() {
        return this.in;
    }

    protected final synchronized OutputStream getOutputStream() {
        return this.out;
    }

    public final synchronized void detach() {
        this.in = null;
        this.out = null;
        this.attached = false;
    }

    public final void addExceptionHandler(ConnProcessorExceptionHandler connProcessorExceptionHandler) {
        DefensiveTools.checkNull(connProcessorExceptionHandler, "handler");
        this.errorHandlers.addIfAbsent(connProcessorExceptionHandler);
    }

    public final void removeExceptionHandler(ConnProcessorExceptionHandler connProcessorExceptionHandler) {
        DefensiveTools.checkNull(connProcessorExceptionHandler, "handler");
        this.errorHandlers.remove(connProcessorExceptionHandler);
    }

    public final void handleException(ErrorType errorType, Throwable throwable) {
        this.handleException(errorType, throwable, null);
    }

    public final void handleException(ErrorType errorType, Throwable throwable, Object object) {
        DefensiveTools.checkNull(errorType, "type");
        DefensiveTools.checkNull(throwable, "t");
        boolean bl = logger.logFineEnabled();
        boolean bl2 = logger.logFinerEnabled();
        if (bl) {
            logger.logFine("Processing connection error (" + errorType + "): " + throwable.getMessage() + ": " + object);
        }
        if (errorType == ConnProcessorExceptionEvent.ERRTYPE_CONNECTION_ERROR && !this.isAttached()) {
            if (bl2) {
                logger.logFine("Ignoring " + errorType + " connection error because " + "processor is not attached");
            }
            return;
        }
        Iterator<ConnProcessorExceptionHandler> iterator = this.errorHandlers.iterator();
        if (!iterator.hasNext()) {
            if (logger.logWarningEnabled()) {
                logger.logException("CONNPROCESSOR HAS NO ERROR HANDLERS, DUMPING:\nERROR TYPE: " + errorType + "\n" + "ERROR INFO: " + object, throwable);
            }
            return;
        }
        ConnProcessorExceptionEvent connProcessorExceptionEvent = new ConnProcessorExceptionEvent(this, errorType, throwable, object);
        while (iterator.hasNext()) {
            ConnProcessorExceptionHandler connProcessorExceptionHandler = iterator.next();
            if (bl2) {
                logger.logFiner("Running ConnProcessor error handler " + connProcessorExceptionHandler);
            }
            try {
                connProcessorExceptionHandler.handleException(connProcessorExceptionEvent);
            }
            catch (Throwable throwable2) {
                if (!logger.logWarningEnabled()) continue;
                logger.logWarning("Exception handler " + connProcessorExceptionHandler + "threw exception: " + throwable2);
            }
        }
    }

    public static final class ErrorType {
        private final String name;

        public ErrorType(String string) {
            DefensiveTools.checkNull(string, "name");
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

