/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.logging;

import net.kano.joscar.DefensiveTools;
import net.kano.joscar.logging.JavaLogManager;
import net.kano.joscar.logging.LogManager;
import net.kano.joscar.logging.Logger;

public final class LoggingSystem {
    private static LogManager logManager = new JavaLogManager();

    private LoggingSystem() {
    }

    public static synchronized Logger getLogger(String string) throws IllegalStateException {
        DefensiveTools.checkNull(string, "namespace");
        Logger logger = logManager.getLogger(string);
        if (logger == null) {
            throw new IllegalStateException("logger for " + string + " is null, logManager is " + logManager);
        }
        return logger;
    }

    public static synchronized LogManager getLogManager() {
        return logManager;
    }

    public static synchronized void setLogManager(LogManager logManager) {
        DefensiveTools.checkNull(logManager, "manager");
        LoggingSystem.logManager = logManager;
    }
}

