/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import net.kano.joscar.DefensiveTools;
import org.jetbrains.annotations.Nullable;

public final class ImEncodingParams {
    public static final int CHARSET_ASCII = 0;
    public static final int CHARSET_ISO = 3;
    public static final int CHARSET_UTF16 = 2;
    public static final int CHARSUBSET_DEFAULT = 0;
    private final int charsetCode;
    private final int charsetSubcode;

    public ImEncodingParams(int n) {
        this(n, 0);
    }

    public ImEncodingParams(int n, int n2) {
        DefensiveTools.checkRange(n, "charsetCode", -1);
        DefensiveTools.checkRange(n2, "charsetSubcode", -1);
        this.charsetCode = n;
        this.charsetSubcode = n2;
    }

    public final int getCharsetCode() {
        return this.charsetCode;
    }

    public final int getCharsetSubcode() {
        return this.charsetSubcode;
    }

    @Nullable
    public final String toCharsetName() {
        if (this.charsetCode == 0 || this.charsetCode == 3) {
            return "ISO-8859-1";
        }
        if (this.charsetCode == 2) {
            return "UTF-16BE";
        }
        return null;
    }

    public String toString() {
        return "ImEncoding: code=" + this.charsetCode + ", subcode=" + this.charsetSubcode + " (Java charset: " + this.toCharsetName() + ")";
    }
}

