/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;

public class DynAsciiCharSequence
implements CharSequence {
    private final ByteBlock data;
    private int length;

    public DynAsciiCharSequence(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "data");
        this.data = byteBlock;
        this.length = byteBlock.getLength();
    }

    public void setLength(int n) {
        this.length = n;
    }

    public char charAt(int n) {
        return (char)this.data.get(n);
    }

    public int length() {
        return this.length;
    }

    public DynAsciiCharSequence subSequence(int n, int n2) {
        return new DynAsciiCharSequence(this.data.subBlock(n, n2 - n));
    }

    public String toString() {
        return BinaryTools.getAsciiString(this.data.subBlock(0, this.length));
    }

    public boolean contains(CharSequence charSequence) {
        return this.indexOf(charSequence) != -1;
    }

    public int indexOf(CharSequence charSequence) {
        return this.indexOf(charSequence, 0);
    }

    public int indexOf(CharSequence charSequence, int n) {
        DefensiveTools.checkRange(n, "fromIndex", 0);
        int n2 = this.length();
        int n3 = charSequence.length();
        if (n >= n2) {
            return n3 == 0 ? n2 : -1;
        }
        if (n3 == 0) {
            return n;
        }
        char c = charSequence.charAt(0);
        int n4 = n2 - n3;
        for (int i = n; i <= n4; ++i) {
            if (this.charAt(i) != c) {
                while (++i <= n4 && this.charAt(i) != c) {
                }
            }
            if (i > n4) continue;
            int n5 = i + 1;
            int n6 = n5 + n3 - 1;
            int n7 = 1;
            while (n5 < n6 && this.charAt(n5) == charSequence.charAt(n7)) {
                ++n5;
                ++n7;
            }
            if (n5 != n6) continue;
            return i;
        }
        return -1;
    }
}

