/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.ShortCapabilityBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CapabilityBlock
implements Writable {
    public static final CapabilityBlock BLOCK_CHAT = new CapabilityBlock(116, 143, 36, 32, 98, 135, 17, 209, 130, 34, 68, 69, 83, 84, 0, 0);
    public static final CapabilityBlock BLOCK_VOICE = ShortCapabilityBlock.getCapFromShortBytes(19, 65);
    public static final CapabilityBlock BLOCK_FILE_SEND = ShortCapabilityBlock.getCapFromShortBytes(19, 67);
    public static final CapabilityBlock BLOCK_DIRECTIM = ShortCapabilityBlock.getCapFromShortBytes(19, 69);
    public static final CapabilityBlock BLOCK_ICON = ShortCapabilityBlock.getCapFromShortBytes(19, 70);
    public static final CapabilityBlock BLOCK_FILE_GET = ShortCapabilityBlock.getCapFromShortBytes(19, 72);
    public static final CapabilityBlock BLOCK_GAMES = ShortCapabilityBlock.getCapFromShortBytes(19, 74);
    public static final CapabilityBlock BLOCK_GAMES2 = new CapabilityBlock(9, 70, 19, 74, 76, 127, 17, 209, 34, 130, 68, 69, 83, 84, 0, 0);
    public static final CapabilityBlock BLOCK_SENDBUDDYLIST = ShortCapabilityBlock.getCapFromShortBytes(19, 75);
    public static final CapabilityBlock BLOCK_TRILLIANCRYPT = new CapabilityBlock(242, 231, 199, 244, 254, 173, 77, 251, 178, 53, 54, 121, 139, 223, 0, 0);
    public static final CapabilityBlock BLOCK_ICQCOMPATIBLE = ShortCapabilityBlock.getCapFromShortBytes(19, 77);
    public static final CapabilityBlock BLOCK_ADDINS = ShortCapabilityBlock.getCapFromShortBytes(19, 71);
    public static final CapabilityBlock BLOCK_SOMETHING = ShortCapabilityBlock.getCapFromShortBytes(1, 255);
    public static final CapabilityBlock BLOCK_SHORTCAPS = ShortCapabilityBlock.getCapFromShortBytes(0, 0);
    public static final CapabilityBlock BLOCK_ENCRYPTION = ShortCapabilityBlock.getCapFromShortBytes(0, 1);
    public static final CapabilityBlock BLOCK_HIPTOP = ShortCapabilityBlock.getCapFromShortBytes(19, 35);
    public static final CapabilityBlock BLOCK_ICQ_UTF8 = ShortCapabilityBlock.getCapFromShortBytes(19, 78);
    private final ByteBlock block;
    private final int hashCode;

    public static byte[] convertToBytes(List<CapabilityBlock> capabilities) {
        byte[] data = new byte[capabilities.size() * 16];
        for (int i = 0; i < capabilities.size(); ++i) {
            capabilities.get(i).getBlock().copyTo(data, i * 16);
        }
        return data;
    }

    public static List<CapabilityBlock> getCapabilityBlocks(ByteBlock block) {
        ArrayList<CapabilityBlock> blocks = new ArrayList<CapabilityBlock>(block.getLength() / 16);
        ByteBlock nextBlock = block;
        for (int i = 0; i < blocks.size(); ++i) {
            blocks.add(new CapabilityBlock(nextBlock.subBlock(0, 16)));
            nextBlock = nextBlock.subBlock(16);
        }
        return blocks;
    }

    public CapabilityBlock(int a, int b, int c, int d, int e, int f, int g, int h, int i, int j, int k, int l, int m, int n, int o, int p) {
        this(ByteBlock.wrap(new byte[]{(byte)a, (byte)b, (byte)c, (byte)d, (byte)e, (byte)f, (byte)g, (byte)h, (byte)i, (byte)j, (byte)k, (byte)l, (byte)m, (byte)n, (byte)o, (byte)p}));
    }

    public CapabilityBlock(ByteBlock block) throws IllegalArgumentException {
        DefensiveTools.checkNull(block, "block");
        if (block.getLength() != 16) {
            throw new IllegalArgumentException("invalid capability block: length must be 16 (is " + block.getLength() + ")");
        }
        this.block = ByteBlock.wrap(block.toByteArray());
        long longCode = BinaryTools.getLong(block, 0) ^ BinaryTools.getLong(block, 8);
        this.hashCode = (int)(longCode >> 16 ^ longCode & 0xFFL);
    }

    public final ByteBlock getBlock() {
        return this.block;
    }

    @Override
    public final long getWritableLength() {
        return 16L;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.block.write(out);
    }

    public boolean equals(Object other) {
        if (!(other instanceof CapabilityBlock)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        CapabilityBlock oc = (CapabilityBlock)other;
        return this.block.equals(oc.block);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        String name = MiscTools.findEqualField(CapabilityBlock.class, this, "BLOCK_.*");
        return "CapabilityBlock: " + BinaryTools.describeData(this.block) + " (" + (name == null ? "unknown capability block" : name) + ")";
    }
}

