/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.buddy;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.buddy.BuddyOfflineCmd;
import net.kano.joscar.snaccmd.buddy.BuddyStatusCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientBuddyCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList(new CmdType(3, 11), new CmdType(3, 12));

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket snacPacket) {
        if (snacPacket.getFamily() != 3) {
            return null;
        }
        int n = snacPacket.getCommand();
        if (n == 11) {
            return new BuddyStatusCmd(snacPacket);
        }
        if (n == 12) {
            return new BuddyOfflineCmd(snacPacket);
        }
        return null;
    }
}

