/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jOutputStream
extends OutputStream {
    private static int DEFAULT_BUFFER_SIZE = 2048;
    private static final char LINE_TERMINATOR = '\n';
    private Level level = Level.DEBUG;
    private Logger logger;
    private ByteArrayOutputStream buffer;

    public Log4jOutputStream(Logger logger, Level level) {
        this(logger, level, DEFAULT_BUFFER_SIZE);
    }

    public Log4jOutputStream(Logger logger, Level level, int size) {
        this.buffer = new ByteArrayOutputStream(size);
        this.level = level;
        this.logger = logger;
    }

    public void write(int val) throws IOException {
        if (val != 10) {
            this.buffer.write(val);
        } else {
            this.logger.log((Priority)this.level, (Object)this.buffer.toString());
            this.buffer.reset();
        }
    }

    public void flush() throws IOException {
        this.logger.log((Priority)this.level, (Object)this.buffer.toString());
        this.buffer.reset();
    }
}

