/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.out;

import java.nio.ByteBuffer;
import java.util.List;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets.out.ClusterCommandPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterCreatePacket
extends ClusterCommandPacket {
    private byte type;
    private byte authType;
    private int oldCategory;
    private int category;
    private String name;
    private String notice;
    private String description;
    private List<Integer> members;

    public ClusterCreatePacket(QQUser qQUser) {
        super(qQUser);
        this.subCommand = 1;
        this.type = 1;
        this.authType = (byte)2;
        this.oldCategory = 0;
    }

    public ClusterCreatePacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    @Override
    public String getPacketName() {
        return "Cluster Create _08Packet";
    }

    @Override
    protected void putBody(ByteBuffer byteBuffer) {
        byteBuffer.put(this.subCommand);
        byteBuffer.put(this.type);
        byteBuffer.put(this.authType);
        byteBuffer.putInt(this.oldCategory);
        byteBuffer.putInt(this.category);
        byte[] byArray = this.name.getBytes();
        byteBuffer.put((byte)(byArray.length & 0xFF));
        byteBuffer.put(byArray);
        byteBuffer.putChar('\u0000');
        byArray = this.notice.getBytes();
        byteBuffer.put((byte)(byArray.length & 0xFF));
        byteBuffer.put(byArray);
        byArray = this.description.getBytes();
        byteBuffer.put((byte)(byArray.length & 0xFF));
        byteBuffer.put(byArray);
        for (int n : this.members) {
            byteBuffer.putInt(n);
        }
    }

    public byte getAuthType() {
        return this.authType;
    }

    public void setAuthType(byte by) {
        this.authType = by;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getNotice() {
        return this.notice;
    }

    public void setNotice(String string) {
        this.notice = string;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte by) {
        this.type = by;
    }

    public List<Integer> getMembers() {
        return this.members;
    }

    public void setMembers(List<Integer> list) {
        this.members = list;
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int n) {
        this.category = n;
    }

    public int getOldCategory() {
        return this.oldCategory;
    }

    public void setOldCategory(int n) {
        this.oldCategory = n;
    }
}

