/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum YahooProtocol {
    YAHOO(0),
    LCS(1),
    MSN(2),
    LOTUS(9);

    private int value;

    private YahooProtocol(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public String getStringValue() {
        return "" + this.value;
    }

    public static YahooProtocol getProtocol(int value) throws IllegalArgumentException {
        YahooProtocol[] all = YahooProtocol.values();
        for (int i = 0; i < all.length; ++i) {
            if (all[i].getValue() != value) continue;
            return all[i];
        }
        throw new IllegalArgumentException("No YahooProtocol matching long value '" + value + "'.");
    }

    public static YahooProtocol getProtocol(String protocol) throws IllegalArgumentException {
        if (protocol == null || protocol.trim().length() == 0) {
            return YAHOO;
        }
        int value = Integer.parseInt(protocol);
        return YahooProtocol.getProtocol(value);
    }
}

