/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.operation.AbstractMultipleEntryOperation;
import com.hazelcast.map.impl.operation.PartitionWideEntryBackupOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class PartitionWideEntryOperation
extends AbstractMultipleEntryOperation
implements BackupAwareOperation {
    public PartitionWideEntryOperation(String name, EntryProcessor entryProcessor) {
        super(name, entryProcessor);
    }

    public PartitionWideEntryOperation() {
    }

    @Override
    public void innerBeforeRun() {
        super.innerBeforeRun();
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        ManagedContext managedContext = serializationService.getManagedContext();
        managedContext.initialize(this.entryProcessor);
    }

    @Override
    public void run() {
        long now = this.getNow();
        Iterator<Record> iterator = this.recordStore.iterator(now, false);
        while (iterator.hasNext()) {
            Object value;
            Record record = iterator.next();
            Data dataKey = record.getKey();
            Object oldValue = record.getValue();
            Object key = this.toObject(dataKey);
            if (!this.applyPredicate(dataKey, key, value = this.toObject(oldValue))) continue;
            Map.Entry entry = this.createMapEntry(key, value);
            Data response = this.process(entry);
            this.addToResponses(dataKey, response);
            if (this.noOp(entry, oldValue) || this.entryRemoved(entry, dataKey, oldValue, now)) continue;
            this.entryAddedOrUpdated(entry, dataKey, oldValue, now);
            this.evict(false);
        }
    }

    @Override
    public Object getResponse() {
        return this.responses;
    }

    @Override
    public boolean shouldBackup() {
        return this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getSyncBackupCount() {
        return 0;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getTotalBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return backupProcessor != null ? new PartitionWideEntryBackupOperation(this.name, backupProcessor) : null;
    }

    private boolean applyPredicate(Data dataKey, Object key, Object value) {
        if (this.getPredicate() == null) {
            return true;
        }
        SerializationService ss = this.getNodeEngine().getSerializationService();
        QueryEntry queryEntry = new QueryEntry(ss, dataKey, key, value);
        return this.getPredicate().apply(queryEntry);
    }

    protected Predicate getPredicate() {
        return null;
    }

    @Override
    public String toString() {
        return "PartitionWideEntryOperation{}";
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }
}

