/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.util.HashMap;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdFileBackendFactory;
import org.jrobin.core.RrdMemoryBackendFactory;
import org.jrobin.core.RrdNioBackendFactory;
import org.jrobin.core.RrdSafeFileBackendFactory;

public abstract class RrdBackendFactory {
    private static final HashMap<String, RrdBackendFactory> factories = new HashMap();
    private static RrdBackendFactory defaultFactory;

    private static void selectDefaultFactory() throws RrdException {
        String string = System.getProperty("java.version");
        if (string == null || string.startsWith("1.3.") || string.startsWith("1.4.0") || string.startsWith("1.4.1")) {
            RrdBackendFactory.setDefaultFactory("FILE");
        } else {
            RrdBackendFactory.setDefaultFactory("NIO");
        }
    }

    public static synchronized RrdBackendFactory getFactory(String string) throws RrdException {
        RrdBackendFactory rrdBackendFactory = factories.get(string);
        if (rrdBackendFactory != null) {
            return rrdBackendFactory;
        }
        throw new RrdException("No backend factory found with the name specified [" + string + "]");
    }

    public static synchronized void registerFactory(RrdBackendFactory rrdBackendFactory) throws RrdException {
        String string = rrdBackendFactory.getFactoryName();
        if (factories.containsKey(string)) {
            throw new RrdException("Backend factory of this name2 (" + string + ") already exists and cannot be registered");
        }
        factories.put(string, rrdBackendFactory);
    }

    public static synchronized void registerAndSetAsDefaultFactory(RrdBackendFactory rrdBackendFactory) throws RrdException {
        RrdBackendFactory.registerFactory(rrdBackendFactory);
        RrdBackendFactory.setDefaultFactory(rrdBackendFactory.getFactoryName());
    }

    public static RrdBackendFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(String string) throws RrdException {
        if (RrdBackend.isInstanceCreated()) {
            throw new RrdException("Could not change the default backend factory. This method must be called before the first RRD gets created");
        }
        defaultFactory = RrdBackendFactory.getFactory(string);
    }

    protected abstract RrdBackend open(String var1, boolean var2) throws IOException;

    protected abstract boolean exists(String var1) throws IOException;

    public abstract String getFactoryName();

    static {
        try {
            RrdFileBackendFactory rrdFileBackendFactory = new RrdFileBackendFactory();
            RrdBackendFactory.registerFactory(rrdFileBackendFactory);
            RrdMemoryBackendFactory rrdMemoryBackendFactory = new RrdMemoryBackendFactory();
            RrdBackendFactory.registerFactory(rrdMemoryBackendFactory);
            RrdNioBackendFactory rrdNioBackendFactory = new RrdNioBackendFactory();
            RrdBackendFactory.registerFactory(rrdNioBackendFactory);
            RrdSafeFileBackendFactory rrdSafeFileBackendFactory = new RrdSafeFileBackendFactory();
            RrdBackendFactory.registerFactory(rrdSafeFileBackendFactory);
            RrdBackendFactory.selectDefaultFactory();
        }
        catch (RrdException rrdException) {
            throw new RuntimeException("FATAL: Cannot register RRD backend factories: " + rrdException);
        }
    }
}

