/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.ssi;

import java.util.ArrayList;
import java.util.Collection;
import net.kano.joustsim.oscar.oscar.service.ssi.DetectedChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangeTools {
    private ChangeTools() {
    }

    public static <E> void detectChanges(Collection<? extends E> oldItems, Collection<? extends E> newItems, DetectedChangeListener<? super E> listener) {
        if (((Object)oldItems).equals(newItems)) {
            return;
        }
        if (!oldItems.containsAll(newItems)) {
            ArrayList<E> addedItems = new ArrayList<E>(newItems);
            addedItems.removeAll(oldItems);
            assert (!addedItems.isEmpty());
            for (Object group : addedItems) {
                listener.itemAdded(oldItems, newItems, group);
            }
        }
        if (!newItems.containsAll(oldItems)) {
            ArrayList<E> removedItems = new ArrayList<E>(oldItems);
            removedItems.removeAll(newItems);
            assert (!removedItems.isEmpty());
            for (Object group : removedItems) {
                listener.itemRemoved(oldItems, newItems, group);
            }
        }
        ArrayList<E> oldIntersection = new ArrayList<E>(oldItems);
        oldIntersection.retainAll(newItems);
        ArrayList<E> newIntersection = new ArrayList<E>(newItems);
        newIntersection.retainAll(oldItems);
        if (!((Object)oldIntersection).equals(newIntersection)) {
            listener.itemsReordered(oldItems, newItems);
        }
    }

    public static boolean areEqual(Object first, Object newName) {
        return first == null ? newName == null : first.equals(newName);
    }
}

