/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm;

import net.kano.joscar.snaccmd.icbm.MissedMsgInfo;
import net.kano.joustsim.Screenname;

public class MissedImInfo {
    public static final Reason REASON_TOO_FAST = new Reason("TOO_FAST", 2);
    public static final Reason REASON_TOO_LARGE = new Reason("TOO_LARGE", 1);
    public static final Reason REASON_SENDER_WARNING_LEVEL = new Reason("SENDER_WARNING_LEVEL", 3);
    public static final Reason REASON_YOUR_WARNING_LEVEL = new Reason("YOUR_WARNING_LEVEL", 4);
    private final Screenname from;
    private final Screenname to;
    private final int count;
    private final Reason reason;

    static MissedImInfo getInstance(Screenname to, MissedMsgInfo msg) {
        int reason = msg.getReasonCode();
        Reason robj = reason == REASON_TOO_FAST.getCode() ? REASON_TOO_FAST : (reason == REASON_TOO_LARGE.getCode() ? REASON_TOO_LARGE : (reason == REASON_SENDER_WARNING_LEVEL.getCode() ? REASON_SENDER_WARNING_LEVEL : (reason == REASON_YOUR_WARNING_LEVEL.getCode() ? REASON_YOUR_WARNING_LEVEL : new Reason(reason))));
        Screenname from = new Screenname(msg.getUserInfo().getScreenname());
        return new MissedImInfo(from, to, msg.getNumberMissed(), robj);
    }

    private MissedImInfo(Screenname from, Screenname to, int count, Reason reason) {
        this.from = from;
        this.to = to;
        this.count = count;
        this.reason = reason;
    }

    public Screenname getFrom() {
        return this.from;
    }

    public Screenname getTo() {
        return this.to;
    }

    public int getCount() {
        return this.count;
    }

    public Reason getReason() {
        return this.reason;
    }

    public static final class Reason {
        private final String name;
        private final int code;

        private Reason(int code) {
            this("UNKNOWN", code);
        }

        private Reason(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public int getCode() {
            return this.code;
        }

        public String toString() {
            return this.getName() + "(" + this.getCode() + ")";
        }
    }
}

