/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.jce.provider.PEMUtil;
import org.bouncycastle.jce.provider.PKIXCertPath;
import org.bouncycastle.jce.provider.ProviderUtil;
import org.bouncycastle.jce.provider.X509CRLObject;
import org.bouncycastle.jce.provider.X509CertificateObject;

public class JDKX509CertificateFactory
extends CertificateFactorySpi {
    private static final PEMUtil PEM_CERT_PARSER = new PEMUtil("CERTIFICATE");
    private static final PEMUtil PEM_CRL_PARSER = new PEMUtil("CRL");
    private ASN1Set sData = null;
    private int sDataObjectCount = 0;
    private InputStream currentStream = null;
    private ASN1Set sCrlData = null;
    private int sCrlDataObjectCount = 0;
    private InputStream currentCrlStream = null;

    private Certificate readDERCertificate(ASN1InputStream aSN1InputStream) throws IOException, CertificateParsingException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        if (aSN1Sequence.size() > 1 && aSN1Sequence.getObjectAt(0) instanceof DERObjectIdentifier && aSN1Sequence.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true)).getCertificates();
            return this.getCertificate();
        }
        return new X509CertificateObject(X509CertificateStructure.getInstance(aSN1Sequence));
    }

    private Certificate getCertificate() throws CertificateParsingException {
        if (this.sData != null) {
            while (this.sDataObjectCount < this.sData.size()) {
                DEREncodable dEREncodable;
                if (!((dEREncodable = this.sData.getObjectAt(this.sDataObjectCount++)) instanceof ASN1Sequence)) continue;
                return new X509CertificateObject(X509CertificateStructure.getInstance(dEREncodable));
            }
        }
        return null;
    }

    private Certificate readPEMCertificate(InputStream inputStream) throws IOException, CertificateParsingException {
        ASN1Sequence aSN1Sequence = PEM_CERT_PARSER.readPEMObject(inputStream);
        if (aSN1Sequence != null) {
            return new X509CertificateObject(X509CertificateStructure.getInstance(aSN1Sequence));
        }
        return null;
    }

    private CRL readPEMCRL(InputStream inputStream) throws IOException, CRLException {
        ASN1Sequence aSN1Sequence = PEM_CRL_PARSER.readPEMObject(inputStream);
        if (aSN1Sequence != null) {
            return new X509CRLObject(CertificateList.getInstance(aSN1Sequence));
        }
        return null;
    }

    private CRL readDERCRL(ASN1InputStream aSN1InputStream) throws IOException, CRLException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        if (aSN1Sequence.size() > 1 && aSN1Sequence.getObjectAt(0) instanceof DERObjectIdentifier && aSN1Sequence.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sCrlData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true)).getCRLs();
            return this.getCRL();
        }
        return new X509CRLObject(CertificateList.getInstance(aSN1Sequence));
    }

    private CRL getCRL() throws CRLException {
        if (this.sCrlData == null || this.sCrlDataObjectCount >= this.sCrlData.size()) {
            return null;
        }
        return new X509CRLObject(CertificateList.getInstance(this.sCrlData.getObjectAt(this.sCrlDataObjectCount++)));
    }

    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        if (this.currentStream == null) {
            this.currentStream = inputStream;
            this.sData = null;
            this.sDataObjectCount = 0;
        } else if (this.currentStream != inputStream) {
            this.currentStream = inputStream;
            this.sData = null;
            this.sDataObjectCount = 0;
        }
        try {
            if (this.sData != null) {
                if (this.sDataObjectCount != this.sData.size()) {
                    return this.getCertificate();
                }
                this.sData = null;
                this.sDataObjectCount = 0;
                return null;
            }
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(10);
            int n = inputStream.read();
            if (n == -1) {
                return null;
            }
            if (n != 48) {
                inputStream.reset();
                return this.readPEMCertificate(inputStream);
            }
            inputStream.reset();
            return this.readDERCertificate(new ASN1InputStream(inputStream, ProviderUtil.getReadLimit(inputStream)));
        }
        catch (Exception exception) {
            throw new CertificateException(exception.toString());
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        Certificate certificate;
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        while ((certificate = this.engineGenerateCertificate(inputStream)) != null) {
            arrayList.add(certificate);
        }
        return arrayList;
    }

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        if (this.currentCrlStream == null) {
            this.currentCrlStream = inputStream;
            this.sCrlData = null;
            this.sCrlDataObjectCount = 0;
        } else if (this.currentCrlStream != inputStream) {
            this.currentCrlStream = inputStream;
            this.sCrlData = null;
            this.sCrlDataObjectCount = 0;
        }
        try {
            if (this.sCrlData != null) {
                if (this.sCrlDataObjectCount != this.sCrlData.size()) {
                    return this.getCRL();
                }
                this.sCrlData = null;
                this.sCrlDataObjectCount = 0;
                return null;
            }
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(10);
            if (inputStream.read() != 48) {
                inputStream.reset();
                return this.readPEMCRL(inputStream);
            }
            inputStream.reset();
            return this.readDERCRL(new ASN1InputStream(inputStream, ProviderUtil.getReadLimit(inputStream)));
        }
        catch (CRLException cRLException) {
            throw cRLException;
        }
        catch (Exception exception) {
            throw new CRLException(exception.toString());
        }
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        CRL cRL;
        ArrayList<CRL> arrayList = new ArrayList<CRL>();
        while ((cRL = this.engineGenerateCRL(inputStream)) != null) {
            arrayList.add(cRL);
        }
        return arrayList;
    }

    public Iterator engineGetCertPathEncodings() {
        return PKIXCertPath.certPathEncodings.iterator();
    }

    public CertPath engineGenerateCertPath(InputStream inputStream) throws CertificateException {
        return this.engineGenerateCertPath(inputStream, "PkiPath");
    }

    public CertPath engineGenerateCertPath(InputStream inputStream, String string) throws CertificateException {
        return new PKIXCertPath(inputStream, string);
    }

    public CertPath engineGenerateCertPath(List list) throws CertificateException {
        for (Object e : list) {
            if (e == null || e instanceof X509Certificate) continue;
            throw new CertificateException("list contains non X509Certificate object while creating CertPath\n" + e.toString());
        }
        return new PKIXCertPath(list);
    }
}

