/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.jaxp;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;
import weblogic.xml.babel.parsers.SAXDriver;

public class SAXParserImpl
extends SAXParser {
    private boolean namespaces = true;
    private boolean validation = false;
    private XMLReader reader = null;

    protected SAXParserImpl() {
    }

    protected SAXParserImpl(boolean bl, boolean bl2) throws ParserConfigurationException {
        SAXDriver sAXDriver = new SAXDriver();
        try {
            sAXDriver.setFeature("http://xml.org/sax/features/namespaces", bl);
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException("Cannot set namespace awareness to " + bl);
        }
        try {
            sAXDriver.setFeature("http://xml.org/sax/features/validation", bl2);
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException("Cannot set validation to " + bl2);
        }
        this.namespaces = bl;
        this.validation = bl2;
        this.reader = sAXDriver;
    }

    public Parser getParser() {
        return new XMLReaderAdapter(this.reader);
    }

    public XMLReader getXMLReader() throws SAXException {
        return this.reader;
    }

    public boolean isNamespaceAware() {
        return this.namespaces;
    }

    public boolean isValidating() {
        return this.validation;
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Feature: " + string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Feature: " + string);
    }
}

