/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.util.Date;
import java.util.Vector;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class ResourceUtils {
    public static Resource[] selectOutOfDateSources(ProjectComponent projectComponent, Resource[] resourceArray, FileNameMapper fileNameMapper, ResourceFactory resourceFactory) {
        return ResourceUtils.selectOutOfDateSources(projectComponent, resourceArray, fileNameMapper, resourceFactory, FileUtils.newFileUtils().getFileTimestampGranularity());
    }

    public static Resource[] selectOutOfDateSources(ProjectComponent projectComponent, Resource[] resourceArray, FileNameMapper fileNameMapper, ResourceFactory resourceFactory, long l) {
        long l2 = new Date().getTime() + l;
        Vector<Resource> vector = new Vector<Resource>();
        int n = 0;
        while (n < resourceArray.length) {
            String[] stringArray;
            if (resourceArray[n].getLastModified() > l2) {
                projectComponent.log("Warning: " + resourceArray[n].getName() + " modified in the future.", 1);
            }
            if ((stringArray = fileNameMapper.mapFileName(resourceArray[n].getName().replace('/', File.separatorChar))) != null) {
                boolean bl = false;
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (!bl && n2 < stringArray.length) {
                    Resource resource = resourceFactory.getResource(stringArray[n2].replace(File.separatorChar, '/'));
                    if (!resource.isExists()) {
                        projectComponent.log(resourceArray[n].getName() + " added as " + resource.getName() + " doesn't exist.", 3);
                        vector.addElement(resourceArray[n]);
                        bl = true;
                    } else if (!resource.isDirectory() && SelectorUtils.isOutOfDate(resourceArray[n], resource, (int)l)) {
                        projectComponent.log(resourceArray[n].getName() + " added as " + resource.getName() + " is outdated.", 3);
                        vector.addElement(resourceArray[n]);
                        bl = true;
                    } else {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(resource.getName());
                    }
                    ++n2;
                }
                if (!bl) {
                    projectComponent.log(resourceArray[n].getName() + " omitted as " + stringBuffer.toString() + (stringArray.length == 1 ? " is" : " are ") + " up to date.", 3);
                }
            } else {
                projectComponent.log(resourceArray[n].getName() + " skipped - don't know how to handle it", 3);
            }
            ++n;
        }
        Object[] objectArray = new Resource[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

