/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.Genson;
import com.owlike.genson.reflect.BeanDescriptor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public interface BeanDescriptorProvider {
    public <T> BeanDescriptor<T> provide(Class<T> var1, Genson var2);

    public <T> BeanDescriptor<T> provide(Class<T> var1, Type var2, Genson var3);

    public static class CompositeBeanDescriptorProvider
    implements BeanDescriptorProvider {
        private final List<BeanDescriptorProvider> providers;
        private final ConcurrentHashMap<Type, BeanDescriptor<?>> cache = new ConcurrentHashMap();

        public CompositeBeanDescriptorProvider(List<BeanDescriptorProvider> providers) {
            this.providers = new ArrayList<BeanDescriptorProvider>(providers);
        }

        @Override
        public <T> BeanDescriptor<T> provide(Class<T> ofClass, Genson genson) {
            return this.provide(ofClass, ofClass, genson);
        }

        @Override
        public <T> BeanDescriptor<T> provide(Class<T> ofClass, Type type, Genson genson) {
            BeanDescriptor<Object> desc = this.cache.get(type);
            if (desc == null) {
                BeanDescriptorProvider provider;
                Iterator<BeanDescriptorProvider> i$ = this.providers.iterator();
                while (i$.hasNext() && (desc = (provider = i$.next()).provide(ofClass, type, genson)) == null) {
                }
                this.cache.putIfAbsent(type, desc);
            }
            return desc;
        }
    }
}

