/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.attribute;

import de.javawi.jstun.attribute.MessageAttribute;
import de.javawi.jstun.attribute.MessageAttributeException;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.MessageAttributeParsingException;
import de.javawi.jstun.util.Utility;
import de.javawi.jstun.util.UtilityException;

public class ErrorCode
extends MessageAttribute {
    int responseCode;
    String reason;

    public ErrorCode() {
        super(MessageAttributeInterface.MessageAttributeType.ErrorCode);
    }

    public void setResponseCode(int responseCode) throws MessageAttributeException {
        switch (responseCode) {
            case 400: {
                this.reason = "Bad Request";
                break;
            }
            case 401: {
                this.reason = "Unauthorized";
                break;
            }
            case 420: {
                this.reason = "Unkown Attribute";
                break;
            }
            case 430: {
                this.reason = "Stale Credentials";
                break;
            }
            case 431: {
                this.reason = "Integrity Check Failure";
                break;
            }
            case 432: {
                this.reason = "Missing Username";
                break;
            }
            case 433: {
                this.reason = "Use TLS";
                break;
            }
            case 500: {
                this.reason = "Server Error";
                break;
            }
            case 600: {
                this.reason = "Global Failure";
                break;
            }
            default: {
                throw new MessageAttributeException("Response Code is not valid");
            }
        }
        this.responseCode = responseCode;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getReason() {
        return this.reason;
    }

    public byte[] getBytes() throws UtilityException {
        int length = this.reason.length();
        if (length % 4 != 0) {
            length += 4 - length % 4;
        }
        byte[] result = new byte[length += 4];
        System.arraycopy(Utility.integerToTwoBytes(ErrorCode.typeToInteger(this.type)), 0, result, 0, 2);
        System.arraycopy(Utility.integerToTwoBytes(length - 4), 0, result, 2, 2);
        int classHeader = (int)Math.floor((double)this.responseCode / 100.0);
        result[6] = Utility.integerToOneByte(classHeader);
        result[7] = Utility.integerToOneByte(this.responseCode % 100);
        byte[] reasonArray = this.reason.getBytes();
        System.arraycopy(reasonArray, 0, result, 8, reasonArray.length);
        return result;
    }

    public static ErrorCode parse(byte[] data) throws MessageAttributeParsingException {
        try {
            if (data.length < 4) {
                throw new MessageAttributeParsingException("Data array too short");
            }
            byte classHeaderByte = data[3];
            int classHeader = Utility.oneByteToInteger(classHeaderByte);
            if (classHeader < 1 || classHeader > 6) {
                throw new MessageAttributeParsingException("Class parsing error");
            }
            byte numberByte = data[4];
            int number = Utility.oneByteToInteger(numberByte);
            if (number < 0 || number > 99) {
                throw new MessageAttributeParsingException("Number parsing error");
            }
            int responseCode = classHeader * 100 + number;
            ErrorCode result = new ErrorCode();
            result.setResponseCode(responseCode);
            return result;
        }
        catch (UtilityException ue) {
            throw new MessageAttributeParsingException("Parsing error");
        }
        catch (MessageAttributeException mae) {
            throw new MessageAttributeParsingException("Parsing error");
        }
    }
}

