/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.openymsg.network.Session;
import org.openymsg.network.YMSG9Packet;
import org.openymsg.network.YahooIdentity;
import org.openymsg.network.YahooUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YahooConference {
    protected Set<YahooUser> users;
    protected String room;
    protected String message;
    private boolean closed;
    private Queue<YMSG9Packet> packetBuffer;
    private Session parent;
    private YahooIdentity identity;

    YahooConference(YahooIdentity yid, String room, String message, Session ss, boolean b) {
        this.identity = yid;
        this.users = new HashSet<YahooUser>();
        this.parent = ss;
        this.room = room;
        this.message = message;
        this.closed = false;
        this.packetBuffer = b ? new LinkedList<YMSG9Packet>() : null;
    }

    YahooConference(YahooIdentity yid, String room, String message, Session ss) {
        this(yid, room, message, ss, true);
    }

    void closeConference() {
        this.closed = true;
    }

    void reopenConference() {
        this.closed = false;
    }

    public String getName() {
        return this.room;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Set<YahooUser> getMembers() {
        return new HashSet<YahooUser>(this.users);
    }

    public YahooIdentity getIdentity() {
        return this.identity;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("name=").append(this.room).append(" users=").append(this.users.size()).append(" id=").append(this.identity.getId()).append(" closed?=").append(this.closed);
        return sb.toString();
    }

    boolean isInvited() {
        return this.packetBuffer == null;
    }

    Queue<YMSG9Packet> inviteReceived() {
        LinkedList<YMSG9Packet> v = null;
        v = this.packetBuffer != null ? new LinkedList<YMSG9Packet>(this.packetBuffer) : new LinkedList();
        this.packetBuffer = null;
        return v;
    }

    void addPacket(YMSG9Packet packet) {
        if (this.packetBuffer == null) {
            throw new IllegalStateException("Cannot buffer packets, invite already received");
        }
        this.packetBuffer.add(packet);
    }

    public Set<YahooUser> getUsers() {
        return this.users;
    }

    synchronized void addUsers(String[] usernames) {
        for (String username : usernames) {
            this.addUser(username);
        }
    }

    synchronized void addUser(String username) {
        if (!this.exists(username) && !this.parent.isValidYahooID(username)) {
            this.users.add(new YahooUser(username));
        }
    }

    synchronized void removeUser(String username) {
        YahooUser removeMe = null;
        for (YahooUser user : this.users) {
            if (!user.getId().equals(username)) continue;
            removeMe = user;
            break;
        }
        if (removeMe != null) {
            this.users.remove(removeMe);
        }
    }

    private boolean exists(String username) {
        for (YahooUser user : this.users) {
            if (!user.getId().equals(username)) continue;
            return true;
        }
        return false;
    }

    public String getMessage() {
        return this.message;
    }
}

