/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.out;

import pl.mn.communicator.ILocalStatus;
import pl.mn.communicator.packet.GGConversion;
import pl.mn.communicator.packet.GGStatuses;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.out.GGOutgoingPackage;

public class GGNewStatus
implements GGOutgoingPackage,
GGStatuses {
    public static final int GG_NEW_STATUS = 2;
    private static final int MAX_DESCRIPTION = 70;
    private ILocalStatus m_localStatus = null;

    public GGNewStatus(ILocalStatus localStatus) {
        if (localStatus == null) {
            throw new NullPointerException("status cannot be null");
        }
        this.m_localStatus = localStatus;
    }

    public int getPacketType() {
        return 2;
    }

    public int getLength() {
        int length = 4;
        if (this.m_localStatus.getStatusType().isDescriptionStatus() && this.m_localStatus.isDescriptionSet()) {
            length += this.m_localStatus.getDescription().length() + 1;
            if (this.m_localStatus.isReturnDateSet()) {
                length += 4;
            }
        }
        return length;
    }

    public byte[] getContents() {
        int statusToSend = GGConversion.getProtocolStatus(this.m_localStatus, this.m_localStatus.isFriendsOnly(), false);
        byte[] toSend = new byte[this.getLength()];
        toSend[0] = (byte)(statusToSend & 0xFF);
        toSend[1] = (byte)(statusToSend >> 8 & 0xFF);
        toSend[2] = (byte)(statusToSend >> 16 & 0xFF);
        toSend[3] = (byte)(statusToSend >> 24 & 0xFF);
        if (this.m_localStatus.getStatusType().isDescriptionStatus() && this.m_localStatus.isDescriptionSet()) {
            String description = this.trimDescription(this.m_localStatus.getDescription());
            byte[] descBytes = GGUtils.stringToBytes(description);
            for (int i = 0; i < descBytes.length; ++i) {
                toSend[4 + i] = descBytes[i];
            }
            if (this.m_localStatus.isReturnDateSet()) {
                int timeInSeconds = GGUtils.millisToSeconds(this.m_localStatus.getReturnDate().getTime());
                toSend[4 + description.length() + 1] = (byte)(timeInSeconds & 0xFF);
                toSend[4 + description.length() + 2] = (byte)(timeInSeconds >> 8 & 0xFF);
                toSend[4 + description.length() + 3] = (byte)(timeInSeconds >> 16 & 0xFF);
                toSend[4 + description.length() + 4] = (byte)(timeInSeconds >> 24 & 0xFF);
            }
        }
        return toSend;
    }

    private String trimDescription(String description) {
        if (description == null) {
            return null;
        }
        if (description.length() > 70) {
            description = description.substring(0, 69);
        }
        return description;
    }
}

