/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlUtils {
    public static List locateElements(Element element, String string, String string2, String string3) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals(string) && (object = ((Element)node).getAttribute(string2)) != null && ((String)object).equals(string3)) {
                arrayList.add(node);
            }
            if ((object = XmlUtils.locateElements((Element)node, string, string2, string3)) == null) continue;
            arrayList.addAll((Collection<Node>)object);
        }
        return arrayList;
    }

    public static Element locateElement(Element element, String string, String string2, String string3) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals(string) && (object = ((Element)node).getAttribute(string2)) != null && ((String)object).equals(string3)) {
                return (Element)node;
            }
            object = XmlUtils.locateElement((Element)node, string, string2, string3);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static String getText(Element element) {
        Text text = XmlUtils.getTextNode(element);
        if (text == null) {
            return null;
        }
        return text.getData();
    }

    public static Text getTextNode(Element element) {
        return (Text)XmlUtils.getChildByType(element, (short)3);
    }

    public static Node getChildByType(Element element, short s) {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node = nodeList.item(i);
            short s2 = node.getNodeType();
            if (s2 != s || (s2 == 3 || s2 == 4) && ((string = ((Text)node).getData()) == null || string.trim().length() < 1)) continue;
            return node;
        }
        return null;
    }

    public static Element findChild(Element element, String string) {
        if (element == null || string == null) {
            throw new NullPointerException("Parent or tagname were null! parent = " + element + "; tagName = " + string);
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getNodeName().equals(string)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element findChildByChain(Element element, String[] stringArray) {
        if (element == null || stringArray == null) {
            throw new NullPointerException("Parent or tagname were null! parent = " + element + "; tagName = ");
        }
        if (stringArray.length == 0) {
            return element;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getNodeName().equals(stringArray[0])) continue;
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            return XmlUtils.findChildByChain((Element)node, stringArray2);
        }
        return null;
    }

    public static List findChildrenByChain(Element element, String[] stringArray) {
        if (element == null || stringArray == null) {
            throw new NullPointerException("Parent or tagname were null! parent = " + element + "; tagName = ");
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (stringArray.length == 0) {
            arrayList.add(element);
            return arrayList;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getNodeName().equals(stringArray[0])) continue;
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            arrayList.addAll(XmlUtils.findChildrenByChain((Element)node, stringArray2));
        }
        return arrayList;
    }

    public static List findChildren(Element element, String string) {
        if (element == null || string == null) {
            throw new NullPointerException("Parent or tagname were null! parent = " + element + "; tagName = " + string);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getNodeName().equals(string)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }
}

