/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import java.nio.ByteBuffer;

public final class DataHolder {
    final ByteBuffer buffer;
    final int size;
    int partitionHash;

    public DataHolder(int size) {
        this.size = size;
        this.buffer = ByteBuffer.allocate(size);
    }

    public DataHolder(Data data) {
        this.size = data.size();
        this.buffer = ByteBuffer.wrap(data.buffer);
        this.partitionHash = data.getPartitionHash();
    }

    public boolean shouldRead() {
        return this.size > 0 && this.buffer != null && this.buffer.hasRemaining();
    }

    public void read(ByteBuffer src) {
        IOUtil.copyToHeapBuffer(src, this.buffer);
    }

    public void setPartitionHash(int partitionHash) {
        this.partitionHash = partitionHash;
    }

    public int size() {
        return this.size;
    }

    public void postRead() {
        if (this.size > 0) {
            this.buffer.flip();
        }
    }

    public Data toData() {
        Data data = new Data(this.buffer.array());
        data.setPartitionHash(this.partitionHash);
        return data;
    }

    public String toString() {
        return "DataHolder{size=" + this.size + '}';
    }
}

