/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.voice;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.rvcmd.RvConnectionInfo;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.TlvChain;

public class VoiceReqRvCmd
extends AbstractRequestRvCmd {
    public static final long VERSION_DEFAULT = 1L;
    private final long version;
    private final RvConnectionInfo connInfo;

    public VoiceReqRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        TlvChain tlvChain = this.getRvTlvs();
        this.connInfo = RvConnectionInfo.readConnectionInfo(tlvChain);
        ByteBlock byteBlock = this.getServiceData();
        this.version = byteBlock != null ? BinaryTools.getUInt(byteBlock, 0) : -1L;
    }

    public VoiceReqRvCmd(RvConnectionInfo rvConnectionInfo) {
        this(1L, rvConnectionInfo);
    }

    public VoiceReqRvCmd(long l, RvConnectionInfo rvConnectionInfo) {
        super(CapabilityBlock.BLOCK_VOICE);
        DefensiveTools.checkRange(l, "version", -1);
        this.connInfo = rvConnectionInfo;
        this.version = l;
    }

    public final long getVersion() {
        return this.version;
    }

    public final RvConnectionInfo getConnInfo() {
        return this.connInfo;
    }

    protected void writeRvTlvs(OutputStream outputStream) throws IOException {
        if (this.connInfo != null) {
            this.connInfo.write(outputStream);
        }
    }

    protected boolean hasServiceData() {
        return this.version != -1L;
    }

    protected void writeServiceData(OutputStream outputStream) throws IOException {
        if (this.version != -1L) {
            BinaryTools.writeUInt(outputStream, this.version);
        }
    }

    public String toString() {
        return "VoiceReqRvCmd: version=" + this.version + ", connInfo=" + this.connInfo;
    }
}

