/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;

public abstract class SnacFamilyListCmd
extends ConnCommand {
    private final int[] snacFamilies;

    protected SnacFamilyListCmd(int n, SnacPacket snacPacket) {
        super(n);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.snacFamilies = new int[byteBlock.getLength() / 2];
        int n2 = 0;
        while (n2 * 2 < byteBlock.getLength() - 1) {
            this.snacFamilies[n2] = BinaryTools.getUShort(byteBlock, n2 * 2);
            ++n2;
        }
    }

    protected SnacFamilyListCmd(int n, int[] nArray) {
        super(n);
        this.snacFamilies = (int[])(nArray == null ? null : nArray.clone());
    }

    public final int[] getSnacFamilies() {
        return (int[])(this.snacFamilies == null ? null : this.snacFamilies.clone());
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.snacFamilies != null) {
            for (int i = 0; i < this.snacFamilies.length; ++i) {
                BinaryTools.writeUShort(outputStream, this.snacFamilies[i]);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MiscTools.getClassName(this) + ": snac families: ");
        if (this.snacFamilies != null) {
            for (int i = 0; i < this.snacFamilies.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(Integer.toHexString(this.snacFamilies[i]));
            }
        }
        return stringBuffer.toString();
    }
}

