/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.services.server;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;

public class ServiceContext {
    private static final ThreadLocal _localContext = new ThreadLocal();
    private ServletRequest _request;
    private String _serviceName;
    private String _objectId;
    private int _count;

    private ServiceContext() {
    }

    public static void begin(ServletRequest request, String serviceName, String objectId) throws ServletException {
        ServiceContext context = (ServiceContext)_localContext.get();
        if (context == null) {
            context = new ServiceContext();
            _localContext.set(context);
        }
        context._request = request;
        context._serviceName = serviceName;
        context._objectId = objectId;
        ++context._count;
    }

    public static ServletRequest getRequest() {
        ServiceContext context = (ServiceContext)_localContext.get();
        if (context != null) {
            return context._request;
        }
        return null;
    }

    public static String getServiceName() {
        ServiceContext context = (ServiceContext)_localContext.get();
        if (context != null) {
            return context._serviceName;
        }
        return null;
    }

    public static String getObjectId() {
        ServiceContext context = (ServiceContext)_localContext.get();
        if (context != null) {
            return context._objectId;
        }
        return null;
    }

    public static void end() {
        ServiceContext context = (ServiceContext)_localContext.get();
        if (context != null && --context._count == 0) {
            context._request = null;
        }
    }
}

