/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import org.jdesktop.jdic.browser.NativeEventThread;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserListener;
import org.jdesktop.jdic.browser.WebBrowserUtil;
import org.jdesktop.jdic.init.JdicInitException;
import org.jdesktop.jdic.init.JdicManager;

public class WebBrowser
extends Canvas {
    private static final String binary_windows_ie = "IeEmbed.exe";
    private static final String binary_windows_mozilla = "MozEmbed.exe";
    private static final String binary_linux_gtk1 = "mozembed-linux-gtk1.2";
    private static final String binary_linux_gtk2 = "mozembed-linux-gtk2";
    private static final String binary_freebsd_gtk1 = "mozembed-freebsd-gtk1.2";
    private static final String binary_freebsd_gtk2 = "mozembed-freebsd-gtk2";
    private static final String binary_solaris_gtk1 = "mozembed-solaris-gtk1.2";
    private static final String binary_solaris_gtk2 = "mozembed-solaris-gtk2";
    private static String browserBinary;
    private Status status = new Status();
    private MyFocusListener focusListener = new MyFocusListener();
    private static NativeEventThread eventThread;
    private Vector webclientListeners = new Vector();
    private int instanceNum;
    private static int lastInstanceNum;
    private static boolean isRunningOnWindows;
    private static boolean isDebugOn;
    private boolean firstTime = true;

    public WebBrowser() {
        this((URL)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebBrowser(URL uRL) {
        WebBrowser webBrowser = this;
        synchronized (webBrowser) {
            this.instanceNum = lastInstanceNum++;
        }
        eventThread.attachWebBrowser(this);
        if (0 == this.instanceNum) {
            WebBrowser.setBinaryName();
            eventThread.start();
            eventThread.fireNativeEvent(this.instanceNum, 0);
        }
        if (null != uRL) {
            this.setURL(uRL);
        }
        this.setFocusable(true);
        this.addFocusListener(this.focusListener);
    }

    private static void setBinaryName() {
        if (browserBinary != null && browserBinary.length() > 0) {
            return;
        }
        String string = WebBrowserUtil.getBrowserPath();
        if (null == string) {
            WebBrowser.trace("Cant find default browser if you are on windows!");
            WebBrowser.trace("Or environment variable MOZILLA_FIVE_HOME not set if you are on linux/unix!");
            browserBinary = null;
            return;
        }
        String string2 = System.getProperty("os.name");
        if (string2.indexOf("Windows") >= 0) {
            String string3 = string;
            int n = string3.indexOf("mozilla.exe");
            browserBinary = n >= 0 ? binary_windows_mozilla : binary_windows_ie;
        } else {
            String string4 = string + File.separator + "components" + File.separator + "libwidget_gtk2.so";
            File file = new File(string4);
            if (!file.exists()) {
                if (string2.indexOf("Linux") >= 0) {
                    browserBinary = binary_linux_gtk1;
                } else if (string2.indexOf("SunOS") >= 0) {
                    browserBinary = binary_solaris_gtk1;
                } else if (string2.indexOf("FreeBSD") >= 0) {
                    browserBinary = binary_freebsd_gtk1;
                }
            } else if (string2.indexOf("Linux") >= 0) {
                browserBinary = binary_linux_gtk2;
            } else if (string2.indexOf("SunOS") >= 0) {
                browserBinary = binary_solaris_gtk2;
            } else if (string2.indexOf("FreeBSD") >= 0) {
                browserBinary = binary_freebsd_gtk2;
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        if (isRunningOnWindows) {
            eventThread.fireNativeEvent(this.instanceNum, 1);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        eventThread.fireNativeEvent(this.instanceNum, 4, new Rectangle(n, n2, n3, n4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchWebBrowserEvent(WebBrowserEvent webBrowserEvent) {
        Vector vector;
        int n;
        int n2 = webBrowserEvent.getID();
        WebBrowser.trace("Got event from NativeEventThread " + n2);
        String string = "@" + this.instanceNum + "," + n2 + ",";
        if (3001 == n2) {
            URL uRL = null;
            try {
                uRL = new URL(webBrowserEvent.getData());
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = string + (this.willOpenURL(uRL) ? "0" : "1");
            WebBrowser.eventThread.messenger.sendMessage(string);
            return;
        }
        if (3002 == n2) {
            string = string + (this.willOpenWindow() ? "0" : "1");
            WebBrowser.eventThread.messenger.sendMessage(string);
            return;
        }
        if (3008 == n2) {
            String string2 = webBrowserEvent.getData();
            if (string2.startsWith("forward")) {
                this.status.forwardEnabled = string2.substring(8).equals("1");
                WebBrowser.trace("Forward State changed = " + this.status.forwardEnabled);
            } else if (string2.startsWith("back")) {
                this.status.backEnabled = string2.substring(5).equals("1");
                WebBrowser.trace("Back State changed = " + this.status.backEnabled);
            }
            return;
        }
        if (3022 == n2) {
            WebBrowser.trace("Got Event from brower: Focus Rquest!");
            this.requestFocus();
            return;
        }
        WebBrowser webBrowser = this;
        synchronized (webBrowser) {
            n = this.webclientListeners.size();
            if (n == 0) {
                return;
            }
            vector = (Vector)this.webclientListeners.clone();
        }
        block13: for (int i = 0; i < n; ++i) {
            WebBrowserListener webBrowserListener = (WebBrowserListener)vector.elementAt(i);
            switch (n2) {
                case 3003: {
                    webBrowserListener.downloadStarted(webBrowserEvent);
                    continue block13;
                }
                case 3004: {
                    webBrowserListener.downloadCompleted(webBrowserEvent);
                    continue block13;
                }
                case 3005: {
                    webBrowserListener.downloadProgress(webBrowserEvent);
                    continue block13;
                }
                case 3006: {
                    webBrowserListener.downloadError(webBrowserEvent);
                    continue block13;
                }
                case 3010: {
                    webBrowserListener.titleChange(webBrowserEvent);
                    continue block13;
                }
                case 3011: {
                    webBrowserListener.statusTextChange(webBrowserEvent);
                }
            }
        }
    }

    public synchronized void addWebBrowserListener(WebBrowserListener webBrowserListener) {
        if (!this.webclientListeners.contains(webBrowserListener)) {
            this.webclientListeners.addElement(webBrowserListener);
        }
    }

    public synchronized void removeWebBrowserListener(WebBrowserListener webBrowserListener) {
        this.webclientListeners.removeElement(webBrowserListener);
    }

    public URL getURL() {
        eventThread.fireNativeEvent(this.instanceNum, 12);
        if (this.waitForResult()) {
            try {
                return new URL(WebBrowser.eventThread.eventRetString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setURL() {
        eventThread.fireNativeEvent(this.instanceNum, 5, "about:blank");
    }

    public void setURL(URL uRL) {
        this.setURL(uRL, null);
    }

    public void setURL(URL uRL, String string) {
        if (string == null) {
            eventThread.fireNativeEvent(this.instanceNum, 5, uRL.toString());
        } else {
            eventThread.fireNativeEvent(this.instanceNum, 6, uRL.toString());
            eventThread.fireNativeEvent(this.instanceNum, 7, string);
        }
    }

    public void back() {
        eventThread.fireNativeEvent(this.instanceNum, 8);
    }

    public void forward() {
        eventThread.fireNativeEvent(this.instanceNum, 9);
    }

    public void refresh() {
        eventThread.fireNativeEvent(this.instanceNum, 10);
    }

    public void stop() {
        eventThread.fireNativeEvent(this.instanceNum, 11);
    }

    public static void setDebug(boolean bl) {
        isDebugOn = bl;
    }

    static boolean getDebug() {
        return isDebugOn;
    }

    public static String getBrowserBinary() {
        if (browserBinary == null || browserBinary.length() == 0) {
            WebBrowser.setBinaryName();
        }
        return browserBinary;
    }

    public Status getStatus() {
        return this.status;
    }

    protected boolean willOpenURL(URL uRL) {
        if (null == uRL) {
            return true;
        }
        WebBrowser.trace("URL = " + uRL.toString());
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            catch (AccessControlException accessControlException) {
                return false;
            }
        }
        return true;
    }

    protected boolean willOpenWindow() {
        return true;
    }

    int getInstanceNum() {
        return this.instanceNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForResult() {
        if (!this.status.initialized) {
            WebBrowser.trace("You can't call this method before WebBrowser initialized!");
            return false;
        }
        boolean bl = false;
        WebBrowser webBrowser = this;
        synchronized (webBrowser) {
            try {
                this.wait();
                bl = true;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
        return bl;
    }

    int getNativeWindow() {
        return this.nativeGetWindow(System.getProperty("java.home"));
    }

    public void paint(Graphics graphics) {
        if (this.firstTime) {
            this.firstTime = false;
            if (!isRunningOnWindows) {
                eventThread.fireNativeEvent(this.instanceNum, 1);
            }
        }
    }

    private native int nativeGetWindow(String var1);

    static void trace(String string) {
        if (isDebugOn) {
            System.out.println("*** Jtrace: " + string);
        }
    }

    static {
        eventThread = new NativeEventThread();
        lastInstanceNum = 0;
        isRunningOnWindows = false;
        isDebugOn = false;
        try {
            JdicManager jdicManager = JdicManager.getManager();
            jdicManager.initShareNative();
            jdicManager.initBrowserNative();
        }
        catch (JdicInitException jdicInitException) {
            jdicInitException.printStackTrace();
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("jdic");
                return null;
            }
        });
        isRunningOnWindows = System.getProperty("os.name").indexOf("Windows") >= 0;
    }

    class MyFocusListener
    implements FocusListener {
        MyFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            WebBrowser.trace("\nMyFocusListener: focusGained\n");
            eventThread.fireNativeEvent(WebBrowser.this.instanceNum, 13);
        }

        public void focusLost(FocusEvent focusEvent) {
            WebBrowser.trace("\nMyFocusListener: focusLost\n");
            eventThread.fireNativeEvent(WebBrowser.this.instanceNum, 14);
        }
    }

    public static class Status {
        private boolean initialized = false;
        private boolean backEnabled = false;
        private boolean forwardEnabled = false;
        private static String failReason;

        Status() {
            failReason = "WebBrowser has not finish intializing";
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public boolean isBackEnabled() {
            return this.backEnabled;
        }

        public boolean isForwardEnabled() {
            return this.forwardEnabled;
        }

        void setInitStatus(boolean bl) {
            this.initialized = bl;
        }

        void setInitFailReason(String string) {
            failReason = string;
        }
    }
}

