/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLProperties {
    private File file;
    private Document document;
    private Map propertyCache = new HashMap();

    public XMLProperties(String fileName) throws IOException {
        this(new File(fileName));
    }

    public XMLProperties(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        this.buildDoc(reader);
    }

    public XMLProperties(File file) throws IOException {
        this.file = file;
        if (!file.exists()) {
            File tempFile = new File(file.getParentFile(), file.getName() + ".tmp");
            if (tempFile.exists()) {
                System.err.println("WARNING: " + file.getName() + " was not found, but temp file from " + "previous write operation was. Attempting automatic recovery." + " Please check file for data consistency.");
                tempFile.renameTo(file);
            } else {
                throw new FileNotFoundException("XML properties file does not exist: " + file.getName());
            }
        }
        if (!file.canRead()) {
            throw new IOException("XML properties file must be readable: " + file.getName());
        }
        if (!file.canWrite()) {
            throw new IOException("XML properties file must be writable: " + file.getName());
        }
        FileReader reader = new FileReader(file);
        this.buildDoc(reader);
    }

    public synchronized String getProperty(String name) {
        String value = (String)this.propertyCache.get(name);
        if (value != null) {
            return value;
        }
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        for (int i = 0; i < propName.length; ++i) {
            if ((element = element.element(propName[i])) != null) continue;
            return null;
        }
        value = element.getTextTrim();
        if ("".equals(value)) {
            return null;
        }
        this.propertyCache.put(name, value);
        return value;
    }

    public String[] getProperties(String name) {
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        for (int i = 0; i < propName.length - 1; ++i) {
            if ((element = element.element(propName[i])) != null) continue;
            return new String[0];
        }
        Iterator iter = element.elementIterator(propName[propName.length - 1]);
        ArrayList<String> props = new ArrayList<String>();
        while (iter.hasNext()) {
            String value = ((Element)iter.next()).getTextTrim();
            if ("".equals(value)) continue;
            props.add(value);
        }
        String[] childrenNames = new String[props.size()];
        return props.toArray(childrenNames);
    }

    public Iterator getChildProperties(String name) {
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        for (int i = 0; i < propName.length - 1; ++i) {
            if ((element = element.element(propName[i])) != null) continue;
            return Collections.EMPTY_LIST.iterator();
        }
        Iterator iter = element.elementIterator(propName[propName.length - 1]);
        ArrayList<String> props = new ArrayList<String>();
        while (iter.hasNext()) {
            props.add(((Element)iter.next()).getName());
        }
        return props.iterator();
    }

    public String getAttribute(String name, String attribute) {
        String child;
        if (name == null || attribute == null) {
            return null;
        }
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        for (int i = 0; i < propName.length && (element = element.element(child = propName[i])) != null; ++i) {
        }
        if (element != null) {
            return element.attributeValue(attribute);
        }
        return null;
    }

    public void setProperties(String name, List<String> values) {
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        for (int i = 0; i < propName.length - 1; ++i) {
            if (element.element(propName[i]) == null) {
                element.addElement(propName[i]);
            }
            element = element.element(propName[i]);
        }
        String childName = propName[propName.length - 1];
        ArrayList toRemove = new ArrayList();
        Iterator iter = element.elementIterator(childName);
        while (iter.hasNext()) {
            toRemove.add(iter.next());
        }
        iter = toRemove.iterator();
        while (iter.hasNext()) {
            element.remove((Element)iter.next());
        }
        for (String value : values) {
            element.addElement(childName).setText(value);
        }
        this.saveProperties();
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("value", values);
    }

    public String[] getChildrenProperties(String parent) {
        String[] propName = this.parsePropertyName(parent);
        Element element = this.document.getRootElement();
        for (int i = 0; i < propName.length; ++i) {
            if ((element = element.element(propName[i])) != null) continue;
            return new String[0];
        }
        List children = element.elements();
        int childCount = children.size();
        String[] childrenNames = new String[childCount];
        for (int i = 0; i < childCount; ++i) {
            childrenNames[i] = ((Element)children.get(i)).getName();
        }
        return childrenNames;
    }

    public synchronized void setProperty(String name, String value) {
        if (name == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        this.propertyCache.put(name, value);
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        for (int i = 0; i < propName.length; ++i) {
            if (element.element(propName[i]) == null) {
                element.addElement(propName[i]);
            }
            element = element.element(propName[i]);
        }
        element.setText(value);
        this.saveProperties();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("value", value);
    }

    public synchronized void deleteProperty(String name) {
        this.propertyCache.remove(name);
        String[] propName = this.parsePropertyName(name);
        Element element = this.document.getRootElement();
        for (int i = 0; i < propName.length - 1; ++i) {
            if ((element = element.element(propName[i])) != null) continue;
            return;
        }
        element.remove(element.element(propName[propName.length - 1]));
        this.saveProperties();
    }

    private void buildDoc(Reader in) throws IOException {
        try {
            SAXReader xmlReader = new SAXReader();
            this.document = xmlReader.read(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveProperties() {
        boolean error = false;
        File tempFile = null;
        Writer writer = null;
        try {
            tempFile = new File(this.file.getParentFile(), this.file.getName() + ".tmp");
            writer = new FileWriter(tempFile);
            OutputFormat prettyPrinter = OutputFormat.createPrettyPrint();
            XMLWriter xmlWriter = new XMLWriter(writer, prettyPrinter);
            xmlWriter.write(this.document);
        }
        catch (Exception e) {
            e.printStackTrace();
            error = true;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    error = true;
                }
            }
        }
        if (!error) {
            if (!this.file.delete()) {
                System.err.println("Error deleting property file: " + this.file.getAbsolutePath());
                return;
            }
            try {
                XMLProperties.copy(tempFile, this.file);
            }
            catch (Exception e) {
                e.printStackTrace();
                error = true;
            }
            if (!error) {
                tempFile.delete();
            }
        }
    }

    private String[] parsePropertyName(String name) {
        ArrayList<String> propName = new ArrayList<String>(5);
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        while (tokenizer.hasMoreTokens()) {
            propName.add(tokenizer.nextToken());
        }
        return propName.toArray(new String[propName.size()]);
    }

    public void setProperties(Map propertyMap) {
        for (String propertyName : propertyMap.keySet()) {
            String propertyValue = (String)propertyMap.get(propertyName);
            this.setProperty(propertyName, propertyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File inFile, File outFile) throws IOException {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            fin = new FileInputStream(inFile);
            fout = new FileOutputStream(outFile);
            XMLProperties.copy(fin, fout);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException e) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream in, OutputStream out) throws IOException {
        InputStream inputStream = in;
        synchronized (inputStream) {
            OutputStream outputStream = out;
            synchronized (outputStream) {
                int bytesRead;
                byte[] buffer = new byte[256];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }
}

