/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import ymsg.network.HTTPConnection;
import ymsg.network.Session;
import ymsg.network.Util;
import ymsg.network.YahooChatLobby;
import ymsg.network.YahooChatRoom;

public class YahooChatCategory {
    private Session session;
    private String cookieLine;
    protected String name;
    protected long id;
    private int level;
    protected Vector categories;
    protected Vector privateRooms;
    protected Vector publicRooms;
    private static final String PUBLIC_TYPE = "yahoo";
    private static final String PRIVATE_TYPE = "user";
    private static final String PREFIX = "http://";
    private static final String TOP_URL = "insider.msg.yahoo.com/ycontent/?chatcat=0";
    private static final String CAT_URL = "insider.msg.yahoo.com/ycontent/?chatroom_";
    private static String localePrefix = "";
    private static Hashtable chatByNetName = new Hashtable();
    private static transient String inputLine;
    private static YahooChatCategory rootCategory;

    YahooChatCategory(Session session, long l, int n, String string) {
        this.session = session;
        this.id = l;
        this.level = n;
        this.name = Util.entityDecode(string);
        this.categories = new Vector();
        this.privateRooms = null;
        this.publicRooms = null;
        if (this.session != null) {
            String[] stringArray = this.session.getCookies();
            this.cookieLine = stringArray != null ? "Cookie: " + stringArray[0] + "; " + stringArray[1] : null;
        }
    }

    void add(YahooChatCategory yahooChatCategory) {
        this.categories.addElement(yahooChatCategory);
    }

    public Vector getPublicRooms() throws IOException {
        if (this.publicRooms == null) {
            this.loadRooms();
        }
        return this.publicRooms;
    }

    public Vector getPrivateRooms() throws IOException {
        if (this.privateRooms == null) {
            this.loadRooms();
        }
        return this.privateRooms;
    }

    public void refresh() throws IOException {
        this.loadRooms();
    }

    public Vector getCategories() {
        return this.categories;
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    private void loadRooms() throws IOException {
        this.publicRooms = new Vector();
        this.privateRooms = new Vector();
        YahooChatRoom yahooChatRoom = null;
        String string = PREFIX + localePrefix + CAT_URL;
        HTTPConnection hTTPConnection = new HTTPConnection("GET", new URL(string + this.id));
        if (this.cookieLine != null) {
            hTTPConnection.println(this.cookieLine);
        }
        hTTPConnection.println("");
        String string2 = hTTPConnection.readLine();
        while (string2 != null && string2.trim().length() > 0 && !string2.startsWith("<")) {
            string2 = hTTPConnection.readLine();
        }
        if (string2.trim().length() == 0) {
            string2 = hTTPConnection.readLine();
        }
        inputLine = string2;
        string2 = YahooChatCategory.nextTag(hTTPConnection);
        while (string2 != null) {
            Object object;
            Hashtable hashtable;
            if (string2.startsWith("<room ")) {
                hashtable = YahooChatCategory.getAttrs(string2);
                String string3 = (String)hashtable.get("type");
                long l = Long.parseLong((String)hashtable.get("id"));
                String string4 = (String)hashtable.get("name");
                object = (String)hashtable.get("topic");
                yahooChatRoom = new YahooChatRoom(l, string4, (String)object, string3.equals(PUBLIC_TYPE));
            } else if (string2.startsWith("</room>")) {
                if (yahooChatRoom.isPublic()) {
                    this.publicRooms.addElement(yahooChatRoom);
                } else {
                    this.privateRooms.addElement(yahooChatRoom);
                }
            } else if (string2.startsWith("<lobby ")) {
                hashtable = YahooChatCategory.getAttrs(string2);
                int n = Integer.parseInt(this._getDef(hashtable, "count", "0"));
                int n2 = Integer.parseInt(this._getDef(hashtable, "users", "0"));
                int n3 = Integer.parseInt(this._getDef(hashtable, "voices", "0"));
                int n4 = Integer.parseInt(this._getDef(hashtable, "webcams", "0"));
                object = new YahooChatLobby(n, n2, n3, n4);
                yahooChatRoom.addLobby((YahooChatLobby)object);
                chatByNetName.put(((YahooChatLobby)object).getNetworkName(), object);
            }
            string2 = YahooChatCategory.nextTag(hTTPConnection);
        }
        hTTPConnection.close();
    }

    private String _getDef(Hashtable hashtable, String string, String string2) {
        if (hashtable.containsKey(string)) {
            return (String)hashtable.get(string);
        }
        return string2;
    }

    public static YahooChatCategory loadCategories() throws IOException {
        return YahooChatCategory.loadCategories(null);
    }

    public static YahooChatCategory loadCategories(Session session) throws IOException {
        if (rootCategory != null) {
            return rootCategory;
        }
        Stack<YahooChatCategory> stack = new Stack<YahooChatCategory>();
        rootCategory = new YahooChatCategory(session, 0L, 0, "<root>");
        stack.push(rootCategory);
        String string = PREFIX + localePrefix + TOP_URL;
        HTTPConnection hTTPConnection = new HTTPConnection("GET", new URL(string));
        if (YahooChatCategory.rootCategory.cookieLine != null) {
            hTTPConnection.println(YahooChatCategory.rootCategory.cookieLine);
        }
        hTTPConnection.println("");
        hTTPConnection.flush();
        String string2 = hTTPConnection.readLine();
        while (string2 != null && string2.trim().length() > 0 && string2.charAt(0) != '<') {
            string2 = hTTPConnection.readLine();
        }
        inputLine = string2;
        string2 = YahooChatCategory.nextTag(hTTPConnection);
        int n = 0;
        while (string2 != null) {
            Hashtable hashtable;
            if (string2.startsWith("<content ")) {
                hashtable = YahooChatCategory.getAttrs(string2);
                YahooChatCategory.rootCategory.id = Long.parseLong((String)hashtable.get("time"));
            } else if (string2.startsWith("<category ")) {
                ++n;
                try {
                    hashtable = YahooChatCategory.getAttrs(string2);
                    long l = Long.parseLong((String)hashtable.get("id"));
                    String string3 = (String)hashtable.get("name");
                    YahooChatCategory yahooChatCategory = new YahooChatCategory(session, l, n, string3);
                    YahooChatCategory yahooChatCategory2 = (YahooChatCategory)stack.peek();
                    yahooChatCategory2.add(yahooChatCategory);
                    stack.push(yahooChatCategory);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (string2.startsWith("</category>")) {
                stack.pop();
            }
            string2 = YahooChatCategory.nextTag(hTTPConnection);
        }
        hTTPConnection.close();
        return rootCategory;
    }

    public static void setLocalePrefix(String string) {
        localePrefix = string == null ? "" : string + ".";
    }

    private static String nextTag(HTTPConnection hTTPConnection) throws IOException {
        if (inputLine == null) {
            return null;
        }
        while (inputLine.trim().length() <= 0 || inputLine.indexOf("<") < 0) {
            inputLine = hTTPConnection.readLine();
            if (inputLine != null) continue;
            return null;
        }
        inputLine = inputLine.substring(inputLine.indexOf("<"));
        int n = inputLine.indexOf(">");
        String string = null;
        if (n >= 0) {
            string = inputLine.substring(0, n + 1);
            inputLine = inputLine.substring(n + 1);
        } else {
            string = inputLine;
            inputLine = "";
        }
        return string;
    }

    private static Hashtable getAttrs(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = string.indexOf("=\"");
        while (n >= 0) {
            int n2 = n + 2;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 2);
            n = string2.indexOf(" ");
            if (n >= 0) {
                string2 = string2.substring(n + 1);
            }
            if ((n = string3.indexOf("\"")) >= 0) {
                string3 = string3.substring(0, n);
            }
            hashtable.put(string2, string3);
            string = string.substring(n2 += string3.length() + 1);
            n = string.indexOf("=\"");
        }
        return hashtable;
    }

    static YahooChatLobby getLobby(String string) {
        return (YahooChatLobby)chatByNetName.get(string);
    }

    public String toString() {
        return "name=" + this.name + " id=" + this.id;
    }

    void printGraph(String string) {
        if (this.categories.size() > 0) {
            System.out.println(string + "<" + this.name + ">");
            for (int i = 0; i < this.categories.size(); ++i) {
                ((YahooChatCategory)this.categories.elementAt(i)).printGraph(string + "  ");
            }
            System.out.println(string + "</" + this.name + ">");
        } else {
            System.out.println(string + this.name);
        }
    }

    private static void dump(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            YahooChatRoom yahooChatRoom = (YahooChatRoom)vector.elementAt(i);
            System.out.println(yahooChatRoom.toString());
            Vector vector2 = yahooChatRoom.getLobbies();
            for (int j = 0; j < vector2.size(); ++j) {
                System.out.println("  " + ((YahooChatLobby)vector2.elementAt(j)).toString());
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            YahooChatCategory yahooChatCategory = YahooChatCategory.loadCategories();
            yahooChatCategory.printGraph("");
            yahooChatCategory = (YahooChatCategory)yahooChatCategory.getCategories().elementAt(0);
            YahooChatCategory.dump(yahooChatCategory.getPublicRooms());
            YahooChatCategory.dump(yahooChatCategory.getPrivateRooms());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

