/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.Iterator;
import net.sf.cindy.SessionListener;
import net.sf.cindy.impl.Constants;
import net.sf.cindy.impl.SecureSocketSession;
import net.sf.cindy.impl.ServerSocketSession;
import net.sf.cindy.impl.SocketSession;
import net.sf.cindy.util.CopyOnWriteCollection;

public class SimpleServerSocketSession
extends ServerSocketSession {
    private final Collection listeners = new CopyOnWriteCollection();

    public void addSocketSessionListener(SessionListener sessionListener) {
        if (sessionListener != null) {
            this.listeners.add(sessionListener);
        }
    }

    public void removeSocketSessionListener(SessionListener sessionListener) {
        if (sessionListener != null) {
            this.listeners.remove(sessionListener);
        }
    }

    protected SocketSession buildSession(SocketAddress socketAddress) {
        SocketSession socketSession = null;
        socketSession = this.getSSLContext() != null && Constants.SUPPORT_SSL ? new SecureSocketSession() : new SocketSession();
        socketSession.setMessageRecognizer(this.getMessageRecognizer());
        socketSession.setDispatcher(this.getDispatcher());
        socketSession.setEventGenerator(this.getEventGenerator());
        socketSession.setLogException(this.isLogException());
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            SessionListener sessionListener = (SessionListener)iterator.next();
            socketSession.addSessionListener(sessionListener);
        }
        return socketSession;
    }
}

