/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.partition.PartitionInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PartitionRuntimeState
implements DataSerializable {
    protected final ArrayList<MemberInfo> members = new ArrayList(100);
    private final Collection<ShortPartitionInfo> partitionInfos = new LinkedList<ShortPartitionInfo>();
    private ILogger logger;
    private int version;
    private Collection<MigrationInfo> completedMigrations;
    private Address endpoint;

    public PartitionRuntimeState() {
    }

    public PartitionRuntimeState(ILogger logger, Collection<MemberInfo> memberInfos, InternalPartition[] partitions, Collection<MigrationInfo> migrationInfos, int version) {
        this.logger = logger;
        this.version = version;
        HashMap<Address, Integer> addressIndexes = new HashMap<Address, Integer>(memberInfos.size());
        int memberIndex = 0;
        for (MemberInfo memberInfo : memberInfos) {
            this.addMemberInfo(memberInfo, addressIndexes, memberIndex);
            ++memberIndex;
        }
        this.setPartitions(partitions, addressIndexes);
        this.completedMigrations = migrationInfos != null ? migrationInfos : new ArrayList(0);
    }

    protected void addMemberInfo(MemberInfo memberInfo, Map<Address, Integer> addressIndexes, int memberIndex) {
        this.members.add(memberIndex, memberInfo);
        addressIndexes.put(memberInfo.getAddress(), memberIndex);
    }

    protected void setPartitions(InternalPartition[] partitions, Map<Address, Integer> addressIndexes) {
        LinkedList<String> unmatchAddresses = new LinkedList<String>();
        for (InternalPartition partition : partitions) {
            ShortPartitionInfo partitionInfo = new ShortPartitionInfo(partition.getPartitionId());
            for (int index = 0; index < 7; ++index) {
                Address address = partition.getReplicaAddress(index);
                if (address == null) {
                    partitionInfo.addressIndexes[index] = -1;
                    continue;
                }
                Integer knownIndex = addressIndexes.get(address);
                if (knownIndex == null && index == 0) {
                    unmatchAddresses.add(address + " -> " + partition);
                }
                partitionInfo.addressIndexes[index] = knownIndex == null ? -1 : knownIndex;
            }
            this.partitionInfos.add(partitionInfo);
        }
        if (!unmatchAddresses.isEmpty()) {
            this.logger.warning("Unknown owner addresses in partition state! (Probably they have recently joined to or left the cluster.) " + unmatchAddresses);
        }
    }

    public PartitionInfo[] getPartitions() {
        int size = this.partitionInfos.size();
        PartitionInfo[] result = new PartitionInfo[size];
        for (ShortPartitionInfo partitionInfo : this.partitionInfos) {
            Address[] replicas = new Address[7];
            int partitionId = partitionInfo.partitionId;
            result[partitionId] = new PartitionInfo(partitionId, replicas);
            int[] addressIndexes = partitionInfo.addressIndexes;
            for (int c = 0; c < addressIndexes.length; ++c) {
                int index = addressIndexes[c];
                if (index == -1) continue;
                replicas[c] = this.members.get(index).getAddress();
            }
        }
        return result;
    }

    public List<MemberInfo> getMembers() {
        return this.members;
    }

    public Address getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Address endpoint) {
        this.endpoint = endpoint;
    }

    public Collection<MigrationInfo> getCompletedMigrations() {
        return this.completedMigrations != null ? this.completedMigrations : Collections.emptyList();
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        in.readLong();
        this.version = in.readInt();
        int size = in.readInt();
        HashMap<Address, Integer> addressIndexes = new HashMap<Address, Integer>(size);
        int memberIndex = 0;
        while (size-- > 0) {
            MemberInfo memberInfo = new MemberInfo();
            memberInfo.readData(in);
            this.addMemberInfo(memberInfo, addressIndexes, memberIndex);
            ++memberIndex;
        }
        int partitionCount = in.readInt();
        for (int i = 0; i < partitionCount; ++i) {
            ShortPartitionInfo spi = new ShortPartitionInfo();
            spi.readData(in);
            this.partitionInfos.add(spi);
        }
        int k = in.readInt();
        if (k > 0) {
            this.completedMigrations = new ArrayList<MigrationInfo>(k);
            for (int i = 0; i < k; ++i) {
                MigrationInfo cm = new MigrationInfo();
                cm.readData(in);
                this.completedMigrations.add(cm);
            }
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(0L);
        out.writeInt(this.version);
        int memberSize = this.members.size();
        out.writeInt(memberSize);
        for (MemberInfo memberInfo : this.members) {
            memberInfo.writeData(out);
        }
        out.writeInt(this.partitionInfos.size());
        for (ShortPartitionInfo spi : this.partitionInfos) {
            spi.writeData(out);
        }
        if (this.completedMigrations != null) {
            int k = this.completedMigrations.size();
            out.writeInt(k);
            for (MigrationInfo cm : this.completedMigrations) {
                cm.writeData(out);
            }
        } else {
            out.writeInt(0);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionRuntimeState [" + this.version + "]{\n");
        for (MemberInfo address : this.members) {
            sb.append(address).append('\n');
        }
        sb.append(", completedMigrations=").append(this.completedMigrations);
        sb.append('}');
        return sb.toString();
    }

    public int getVersion() {
        return this.version;
    }

    private static class ShortPartitionInfo
    implements DataSerializable {
        int partitionId;
        final int[] addressIndexes = new int[7];

        ShortPartitionInfo(int partitionId) {
            this.partitionId = partitionId;
        }

        ShortPartitionInfo() {
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.partitionId);
            for (int i = 0; i < 7; ++i) {
                out.writeInt(this.addressIndexes[i]);
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.partitionId = in.readInt();
            for (int i = 0; i < 7; ++i) {
                this.addressIndexes[i] = in.readInt();
            }
        }
    }
}

