/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.out;

import java.nio.ByteBuffer;
import java.util.List;
import net.sf.jqql.Util;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08BasicOutPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendSMSPacket
extends _08BasicOutPacket {
    private char messageSequence;
    private byte[] message;
    private byte contentType;
    private int contentId;
    private byte sendMode;
    private String senderName;
    private List<String> receiverMobile;
    private List<Integer> receiverQQ;

    public SendSMSPacket(QQUser qQUser) {
        super('-', true, qQUser);
        this.messageSequence = '\u0000';
        this.contentType = 0;
        this.contentId = 0;
        this.sendMode = 0;
    }

    public SendSMSPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    @Override
    public String getPacketName() {
        return "Send SMS _08Packet";
    }

    @Override
    protected void putBody(ByteBuffer byteBuffer) {
        byteBuffer.putChar(this.messageSequence);
        byteBuffer.putChar('\u0000');
        byteBuffer.putInt(0);
        byte[] byArray = Util.getBytes(this.senderName);
        if (byArray.length > 13) {
            byteBuffer.put(byArray, 0, 13);
        } else {
            byteBuffer.put(byArray);
            int n = 13 - byArray.length;
            while (n-- > 0) {
                byteBuffer.put((byte)0);
            }
        }
        byteBuffer.put((byte)1);
        byteBuffer.put(this.sendMode);
        byteBuffer.put(this.contentType);
        byteBuffer.putInt(this.contentId);
        byteBuffer.put((byte)1);
        if (this.receiverMobile == null) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)this.receiverMobile.size());
            for (String object : this.receiverMobile) {
                byArray = Util.getBytes(object);
                if (byArray.length > 18) {
                    byteBuffer.put(byArray, 0, 18);
                } else {
                    byteBuffer.put(byArray);
                    int n = 18 - byArray.length;
                    while (n-- > 0) {
                        byteBuffer.put((byte)0);
                    }
                }
                byteBuffer.putChar('\u0000');
                byteBuffer.put((byte)0);
            }
        }
        if (this.receiverQQ == null) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)this.receiverQQ.size());
            for (Integer n : this.receiverQQ) {
                byteBuffer.putInt(n);
            }
        }
        byteBuffer.put((byte)3);
        if (this.message == null) {
            byteBuffer.putChar('\u0000');
        } else {
            byteBuffer.putChar((char)this.message.length);
            byteBuffer.put(this.message);
        }
    }

    public int getContentId() {
        return this.contentId;
    }

    public void setContentId(int n) {
        this.contentId = n;
    }

    public byte getContentType() {
        return this.contentType;
    }

    public void setContentType(byte by) {
        this.contentType = by;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] byArray) {
        this.message = byArray;
    }

    public char getMessageSequence() {
        return this.messageSequence;
    }

    public void setMessageSequence(char c) {
        this.messageSequence = c;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String string) {
        this.senderName = string;
    }

    public byte getSendMode() {
        return this.sendMode;
    }

    public void setSendMode(byte by) {
        this.sendMode = by;
    }

    public List<String> getReceiverMobile() {
        return this.receiverMobile;
    }

    public void setReceiverMobile(List<String> list) {
        this.receiverMobile = list;
    }

    public List<Integer> getReceiverQQ() {
        return this.receiverQQ;
    }

    public void setReceiverQQ(List<Integer> list) {
        this.receiverQQ = list;
    }
}

