/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractClusterOperation;
import com.hazelcast.cluster.JoinOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.TcpIpConnection;
import com.hazelcast.nio.TcpIpConnectionManager;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;

public class BindOperation
extends AbstractClusterOperation
implements JoinOperation {
    private Address localAddress;
    private Address targetAddress;
    private boolean replyBack = false;

    public BindOperation() {
    }

    public BindOperation(Address localAddress) {
        this(localAddress, null, false);
    }

    public BindOperation(Address localAddress, Address targetAddress, boolean replyBack) {
        this.localAddress = localAddress;
        this.targetAddress = targetAddress;
        this.replyBack = replyBack;
    }

    @Override
    public void run() {
        NodeEngineImpl ns = (NodeEngineImpl)this.getNodeEngine();
        TcpIpConnectionManager connectionManager = (TcpIpConnectionManager)ns.getNode().getConnectionManager();
        TcpIpConnection connection = (TcpIpConnection)this.getConnection();
        connectionManager.bind(connection, this.localAddress, this.targetAddress, this.replyBack);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.localAddress = new Address();
        this.localAddress.readData(in);
        boolean hasTarget = in.readBoolean();
        if (hasTarget) {
            this.targetAddress = new Address();
            this.targetAddress.readData(in);
        }
        this.replyBack = in.readBoolean();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.localAddress.writeData(out);
        boolean hasTarget = this.targetAddress != null;
        out.writeBoolean(hasTarget);
        if (hasTarget) {
            this.targetAddress.writeData(out);
        }
        out.writeBoolean(this.replyBack);
    }

    public String toString() {
        return "Bind " + this.localAddress;
    }
}

