/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.java.sip.communicator.impl.protocol.jabber.extensions.DefaultPacketExtensionProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriIQProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.GracefulShutdownIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.RTPLevelRelayType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.DtlsFingerprintPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RawUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtcpmuxPacketExtension;
import net.java.sip.communicator.service.shutdown.ShutdownService;
import net.java.sip.communicator.util.ServiceUtils;
import org.ice4j.ice.harvest.HostCandidateHarvester;
import org.ice4j.stack.StunStack;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.Logger;
import org.jitsi.util.StringUtils;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.IceUdpTransportManager;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.VideobridgeExpireThread;
import org.jitsi.videobridge.log.EventFactory;
import org.jitsi.videobridge.log.LoggingService;
import org.jitsi.videobridge.metrics.MetricService;
import org.jitsi.videobridge.osgi.ServiceUtils2;
import org.jitsi.videobridge.pubsub.PubSubPublisher;
import org.jitsi.videobridge.simulcast.SimulcastLayer;
import org.jitsi.videobridge.simulcast.SimulcastLayersFactory;
import org.jitsi.videobridge.simulcast.SimulcastManager;
import org.jitsi.videobridge.xmpp.ComponentImpl;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.provider.PubSubProvider;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Videobridge {
    public static final String COLIBRI_CLASS = "colibriClass";
    private static final String DEFAULT_OPTIONS_PROPERTY_NAME = "org.jitsi.videobridge.defaultOptions";
    private static String defaultTransportManager;
    static final String ENABLE_MEDIA_RECORDING_PNAME = "org.jitsi.videobridge.ENABLE_MEDIA_RECORDING";
    private static final Logger logger;
    static final String MEDIA_RECORDING_PATH_PNAME = "org.jitsi.videobridge.MEDIA_RECORDING_PATH";
    static final String MEDIA_RECORDING_TOKEN_PNAME = "org.jitsi.videobridge.MEDIA_RECORDING_TOKEN";
    public static final int OPTION_ALLOW_ANY_FOCUS = 2;
    public static final int OPTION_ALLOW_NO_FOCUS = 1;
    static final Random RANDOM;
    public static final String REST_API = "rest";
    public static final String REST_API_PNAME = "org.jitsi.videobridge.rest";
    static final String RTCP_TERMINATION_FALLBACK_STRATEGY_PNAME = "org.jitsi.videobridge.rtcp.fallbackStrategy";
    static final String RTCP_TERMINATION_STRATEGY_PNAME = "org.jitsi.videobridge.rtcp.strategy";
    static final String SHUTDOWN_ALLOWED_SOURCE_REGEXP_PNAME = "org.jitsi.videobridge.shutdown.ALLOWED_SOURCE_REGEXP";
    public static final String XMPP_API = "xmpp";
    public static final String XMPP_API_PNAME = "org.jitsi.videobridge.xmpp";
    private BundleContext bundleContext;
    private final Map<String, Conference> conferences = new HashMap<String, Conference>();
    private int defaultProcessingOptions;
    private boolean shutdownInProgress;
    private Pattern shutdownSourcePattern;

    public static Collection<Videobridge> getVideobridges(BundleContext bundleContext) {
        return ServiceUtils2.getServices(bundleContext, Videobridge.class);
    }

    public Videobridge() {
        new VideobridgeExpireThread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference createConference(String focus) {
        MetricService metricService;
        Conference conference = null;
        do {
            String id = this.generateConferenceID();
            Map<String, Conference> map = this.conferences;
            synchronized (map) {
                if (!this.conferences.containsKey(id)) {
                    conference = new Conference(this, id, focus);
                    this.conferences.put(id, conference);
                }
            }
        } while (conference == null);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Created conference " + conference.getID() + ". The total number of conferences is now " + this.getConferenceCount() + ", channels " + this.getChannelCount() + "."));
        }
        if ((metricService = this.getMetricService()) != null) {
            metricService.publishNumericMetric("Conferences", this.getConferenceCount());
            metricService.startMeasuredTransaction("Conference length", conference.getID());
        }
        return conference;
    }

    private void enableGracefulShutdownMode() {
        if (!this.shutdownInProgress) {
            logger.info((Object)"Entered graceful shutdown mode");
        }
        this.shutdownInProgress = true;
        this.maybeDoShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireConference(Conference conference) {
        boolean expireConference;
        String id = conference.getID();
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            if (conference.equals(this.conferences.get(id))) {
                this.conferences.remove(id);
                expireConference = true;
            } else {
                expireConference = false;
            }
        }
        if (expireConference) {
            conference.expire();
        }
        this.maybeDoShutdown();
    }

    private String generateConferenceID() {
        return Long.toHexString(System.currentTimeMillis() + RANDOM.nextLong());
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    int getChannelCount() {
        int channelCount = 0;
        for (Conference conference : this.getConferences()) {
            for (Content contents : conference.getContents()) {
                channelCount += contents.getChannelCount();
            }
        }
        return channelCount;
    }

    public Collection<ComponentImpl> getComponents() {
        return ComponentImpl.getComponents((BundleContext)this.getBundleContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference getConference(String id, String focus) {
        Conference conference;
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            conference = this.conferences.get(id);
        }
        if (conference != null) {
            String conferenceFocus = conference.getFocus();
            if (focus == null || conferenceFocus == null || focus.equals(conferenceFocus)) {
                conference.touch();
            } else {
                conference = null;
            }
        }
        return conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConferenceCount() {
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            return this.conferences.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference[] getConferences() {
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            Collection<Conference> values = this.conferences.values();
            return values.toArray(new Conference[values.size()]);
        }
    }

    ConfigurationService getConfigurationService() {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext != null) {
            return ServiceUtils2.getService(bundleContext, ConfigurationService.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultTransportManager() {
        Class<Videobridge> clazz = Videobridge.class;
        synchronized (Videobridge.class) {
            if (defaultTransportManager == null) {
                ConfigurationService cfg;
                BundleContext bundleContext = this.getBundleContext();
                if (bundleContext != null && (cfg = ServiceUtils2.getService(bundleContext, ConfigurationService.class)) != null) {
                    defaultTransportManager = cfg.getString(Videobridge.class.getName() + ".defaultTransportManager");
                }
                if (!"urn:xmpp:jingle:transports:ice-udp:1".equals(defaultTransportManager) && !"urn:xmpp:jingle:transports:raw-udp:1".equals(defaultTransportManager)) {
                    defaultTransportManager = "urn:xmpp:jingle:transports:ice-udp:1";
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultTransportManager;
        }
    }

    public LoggingService getLoggingService() {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext != null) {
            return ServiceUtils2.getService(bundleContext, LoggingService.class);
        }
        return null;
    }

    public MetricService getMetricService() {
        if (this.bundleContext != null) {
            return ServiceUtils2.getService(this.bundleContext, MetricService.class);
        }
        return null;
    }

    public IQ handleColibriConferenceIQ(ColibriConferenceIQ conferenceIQ) throws Exception {
        return this.handleColibriConferenceIQ(conferenceIQ, this.defaultProcessingOptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IQ handleColibriConferenceIQ(ColibriConferenceIQ conferenceIQ, int options) throws Exception {
        ColibriConferenceIQ responseConferenceIQ;
        Conference conference;
        String focus = conferenceIQ.getFrom();
        if ((options & 2) > 0) {
            options |= 1;
            focus = null;
        }
        if (focus == null && (options & 1) == 0) {
            return IQ.createErrorResponse((IQ)conferenceIQ, (XMPPError)new XMPPError(XMPPError.Condition.not_authorized));
        }
        String id = conferenceIQ.getID();
        if (id == null) {
            if (this.isShutdownInProgress()) return ColibriConferenceIQ.createGracefulShutdownErrorResponse((IQ)conferenceIQ);
            conference = this.createConference(focus);
        } else {
            conference = this.getConference(id, focus);
        }
        if (conference != null) {
            conference.setLastKnownFocus(conferenceIQ.getFrom());
        }
        if (conference == null) {
            responseConferenceIQ = null;
        } else {
            String strategyFQN;
            ColibriConferenceIQ.RTCPTerminationStrategy strategyIQ;
            String tokenConfig;
            String tokenIQ;
            responseConferenceIQ = new ColibriConferenceIQ();
            conference.describeShallow(responseConferenceIQ);
            responseConferenceIQ.setGracefulShutdown(this.isShutdownInProgress());
            ColibriConferenceIQ.Recording recordingIQ = conferenceIQ.getRecording();
            if (recordingIQ != null && (tokenIQ = recordingIQ.getToken()) != null && tokenIQ.equals(tokenConfig = this.getConfigurationService().getString(MEDIA_RECORDING_TOKEN_PNAME))) {
                boolean recording = conference.setRecording(recordingIQ.getState());
                ColibriConferenceIQ.Recording responseRecordingIq = new ColibriConferenceIQ.Recording(recording);
                if (recording) {
                    responseRecordingIq.setDirectory(conference.getRecordingDirectory());
                }
                responseConferenceIQ.setRecording(responseRecordingIq);
            }
            if ((strategyIQ = conferenceIQ.getRTCPTerminationStrategy()) == null) {
                strategyFQN = null;
            } else {
                strategyFQN = strategyIQ.getName();
                if (strategyFQN != null && (strategyFQN = strategyFQN.trim()).length() == 0) {
                    strategyFQN = null;
                }
            }
            for (ColibriConferenceIQ.Content contentIQ : conferenceIQ.getContents()) {
                Content content = conference.getOrCreateContent(contentIQ.getName());
                if (content == null) {
                    responseConferenceIQ = null;
                } else {
                    if (strategyFQN != null) {
                        content.setRTCPTerminationStrategyFQN(strategyFQN);
                    }
                    ColibriConferenceIQ.Content responseContentIQ = new ColibriConferenceIQ.Content(content.getName());
                    responseConferenceIQ.addContent(responseContentIQ);
                    for (ColibriConferenceIQ.Channel channelIQ : contentIQ.getChannels()) {
                        String transportNamespace;
                        String channelID = channelIQ.getID();
                        int channelExpire = channelIQ.getExpire();
                        String channelBundleId = channelIQ.getChannelBundleId();
                        RtpChannel channel = null;
                        boolean channelCreated = false;
                        String string = transportNamespace = channelIQ.getTransport() != null ? channelIQ.getTransport().getNamespace() : null;
                        if (channelID == null) {
                            if (channelExpire != 0) {
                                channel = content.createRtpChannel(channelBundleId, transportNamespace, channelIQ.isInitiator());
                                channelCreated = true;
                            }
                        } else {
                            channel = (RtpChannel)content.getChannel(channelID);
                        }
                        if (channel == null) {
                            responseConferenceIQ = null;
                        } else {
                            LoggingService loggingService;
                            Boolean initiator;
                            Boolean adaptiveSimulcast;
                            Boolean adaptiveLastN;
                            Integer lastN;
                            String endpoint;
                            RTPLevelRelayType rtpLevelRelayType;
                            if (channelExpire != -1) {
                                channel.setExpire(channelExpire);
                                if (channelExpire == 0 && channel.isExpired()) continue;
                            }
                            if ((rtpLevelRelayType = channelIQ.getRTPLevelRelayType()) != null) {
                                channel.setRTPLevelRelayType(rtpLevelRelayType);
                            }
                            if (channelBundleId != null) {
                                IceUdpTransportManager transportManager = conference.getTransportManager(channelBundleId, true);
                                ((TransportManager)transportManager).addChannel(channel);
                            }
                            if ((endpoint = channelIQ.getEndpoint()) != null) {
                                channel.setEndpoint(endpoint);
                            }
                            if ((lastN = channelIQ.getLastN()) != null) {
                                channel.setLastN(lastN);
                            }
                            if ((adaptiveLastN = channelIQ.getAdaptiveLastN()) != null) {
                                channel.setAdaptiveLastN(adaptiveLastN);
                            }
                            if ((adaptiveSimulcast = channelIQ.getAdaptiveSimulcast()) != null) {
                                channel.setAdaptiveSimulcast(adaptiveSimulcast);
                            }
                            if ((initiator = channelIQ.isInitiator()) != null) {
                                channel.setInitiator(initiator);
                            }
                            channel.setPayloadTypes(channelIQ.getPayloadTypes());
                            channel.setRtpHeaderExtensions(channelIQ.getRtpHeaderExtensions());
                            channel.setTransport(channelIQ.getTransport());
                            channel.setDirection(channelIQ.getDirection());
                            if (channel instanceof VideoChannel) {
                                Integer receivingSimulcastLayer;
                                List sourceGroups = channelIQ.getSourceGroups();
                                VideoChannel videoChannel = (VideoChannel)channel;
                                if (sourceGroups != null) {
                                    SimulcastManager manager = videoChannel.getSimulcastManager();
                                    SortedSet<SimulcastLayer> layers = SimulcastLayersFactory.fromSourceGroups(sourceGroups, manager);
                                    manager.setSimulcastLayers(layers);
                                }
                                if ((receivingSimulcastLayer = channelIQ.getReceivingSimulcastLayer()) != null) {
                                    // empty if block
                                }
                            }
                            ColibriConferenceIQ.Channel responseChannelIQ = new ColibriConferenceIQ.Channel();
                            channel.describe((ColibriConferenceIQ.ChannelCommon)responseChannelIQ);
                            responseContentIQ.addChannel(responseChannelIQ);
                            if (channelCreated && (loggingService = this.getLoggingService()) != null) {
                                loggingService.logEvent(EventFactory.channelCreated(channel.getID(), content.getName(), conference.getID(), endpoint == null ? "" : endpoint, lastN == null ? -1 : lastN));
                            }
                        }
                        if (responseConferenceIQ != null) continue;
                        break;
                    }
                    for (ColibriConferenceIQ.SctpConnection sctpConnIq : contentIQ.getSctpConnections()) {
                        SctpConnection sctpConn;
                        String id2 = sctpConnIq.getID();
                        String endpointID = sctpConnIq.getEndpoint();
                        int expire = sctpConnIq.getExpire();
                        String channelBundleId = sctpConnIq.getChannelBundleId();
                        if (id2 == null) {
                            Endpoint endpoint = endpointID == null ? null : conference.getOrCreateEndpoint(endpointID);
                            sctpConn = content.getSctpConnection(endpoint);
                            if (sctpConn == null) {
                                if (expire == 0) continue;
                                int sctpPort = sctpConnIq.getPort();
                                sctpConn = content.createSctpConnection(endpoint, sctpPort, channelBundleId, sctpConnIq.isInitiator());
                            }
                        } else {
                            sctpConn = content.getSctpConnection(id2);
                            if (sctpConn == null && expire == 0) continue;
                            if (endpointID != null) {
                                sctpConn.setEndpoint(endpointID);
                            }
                        }
                        if (expire != -1) {
                            sctpConn.setExpire(expire);
                        }
                        if (sctpConn.isExpired()) continue;
                        Boolean initiator = sctpConnIq.isInitiator();
                        if (initiator != null) {
                            sctpConn.setInitiator(initiator);
                        }
                        sctpConn.setTransport(sctpConnIq.getTransport());
                        if (channelBundleId != null) {
                            IceUdpTransportManager transportManager = conference.getTransportManager(channelBundleId, true);
                            ((TransportManager)transportManager).addChannel(sctpConn);
                        }
                        ColibriConferenceIQ.SctpConnection responseSctpIq = new ColibriConferenceIQ.SctpConnection();
                        sctpConn.describe((ColibriConferenceIQ.ChannelCommon)responseSctpIq);
                        responseContentIQ.addSctpConnection(responseSctpIq);
                    }
                }
                if (responseConferenceIQ != null) continue;
                break;
            }
            for (ColibriConferenceIQ.ChannelBundle channelBundleIq : conferenceIQ.getChannelBundles()) {
                TransportManager transportManager = conference.getTransportManager(channelBundleIq.getId());
                IceUdpTransportPacketExtension transportIq = channelBundleIq.getTransport();
                if (transportManager == null || transportIq == null) continue;
                transportManager.startConnectivityEstablishment(transportIq);
            }
        }
        if (conference != null) {
            for (ColibriConferenceIQ.Endpoint colibriEndpoint : conferenceIQ.getEndpoints()) {
                conference.updateEndpoint(colibriEndpoint);
            }
            if (responseConferenceIQ != null) {
                conference.describeChannelBundles(responseConferenceIQ);
            }
        }
        if (responseConferenceIQ == null) return responseConferenceIQ;
        responseConferenceIQ.setType(IQ.Type.RESULT);
        return responseConferenceIQ;
    }

    public IQ handleGracefulShutdownIQ(GracefulShutdownIQ shutdownIQ) {
        if (this.shutdownSourcePattern == null) {
            return IQ.createErrorResponse((IQ)shutdownIQ, (XMPPError)new XMPPError(XMPPError.Condition.service_unavailable));
        }
        String from = shutdownIQ.getFrom();
        if (from != null && this.shutdownSourcePattern.matcher(from).matches()) {
            logger.info((Object)("Accepted shutdown request from: " + from));
            if (!this.isShutdownInProgress()) {
                this.enableGracefulShutdownMode();
            }
            return IQ.createResultIQ((IQ)shutdownIQ);
        }
        logger.error((Object)("Rejected shutdown request from: " + from));
        return IQ.createErrorResponse((IQ)shutdownIQ, (XMPPError)new XMPPError(XMPPError.Condition.not_authorized));
    }

    public void handleIQResponse(IQ response) throws Exception {
        PubSubPublisher.handleIQResponse(response);
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeDoShutdown() {
        if (!this.shutdownInProgress) {
            return;
        }
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            if (this.conferences.size() == 0) {
                ShutdownService shutdownService = (ShutdownService)ServiceUtils.getService((BundleContext)this.bundleContext, ShutdownService.class);
                logger.info((Object)"Videobridge is shutting down NOW");
                shutdownService.beginShutdown();
            }
        }
    }

    void start(BundleContext bundleContext) throws Exception {
        List ice4jPropertyNames;
        String shutdownSourcesRegexp;
        ConfigurationService cfg = ServiceUtils2.getService(bundleContext, ConfigurationService.class);
        int n = this.defaultProcessingOptions = cfg == null ? 0 : cfg.getInt(DEFAULT_OPTIONS_PROPERTY_NAME, 0);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Default videobridge processing options: 0x" + Integer.toHexString(this.defaultProcessingOptions)));
        }
        String string = shutdownSourcesRegexp = cfg == null ? null : cfg.getString(SHUTDOWN_ALLOWED_SOURCE_REGEXP_PNAME);
        if (!StringUtils.isNullOrEmpty((String)shutdownSourcesRegexp)) {
            try {
                this.shutdownSourcePattern = Pattern.compile(shutdownSourcesRegexp);
            }
            catch (PatternSyntaxException exc) {
                logger.error((Object)("Error parsing enableGracefulShutdownMode sources reg expr: " + shutdownSourcesRegexp), (Throwable)exc);
            }
        }
        ProviderManager providerManager = ProviderManager.getInstance();
        providerManager.addIQProvider("conference", "http://jitsi.org/protocol/colibri", (Object)new ColibriIQProvider());
        providerManager.addExtensionProvider("transport", "urn:xmpp:jingle:transports:ice-udp:1", (Object)new DefaultPacketExtensionProvider(IceUdpTransportPacketExtension.class));
        providerManager.addExtensionProvider("transport", "urn:xmpp:jingle:transports:raw-udp:1", (Object)new DefaultPacketExtensionProvider(RawUdpTransportPacketExtension.class));
        DefaultPacketExtensionProvider candidatePacketExtensionProvider = new DefaultPacketExtensionProvider(CandidatePacketExtension.class);
        providerManager.addExtensionProvider("candidate", "urn:xmpp:jingle:transports:ice-udp:1", (Object)candidatePacketExtensionProvider);
        providerManager.addExtensionProvider("candidate", "urn:xmpp:jingle:transports:raw-udp:1", (Object)candidatePacketExtensionProvider);
        providerManager.addExtensionProvider("rtcp-mux", "urn:xmpp:jingle:transports:ice-udp:1", (Object)new DefaultPacketExtensionProvider(RtcpmuxPacketExtension.class));
        providerManager.addExtensionProvider("fingerprint", "urn:xmpp:jingle:apps:dtls:0", (Object)new DefaultPacketExtensionProvider(DtlsFingerprintPacketExtension.class));
        providerManager.addIQProvider(PubSubElementType.PUBLISH.getElementName(), PubSubElementType.PUBLISH.getNamespace().getXmlns(), (Object)new PubSubProvider());
        StunStack.setPacketLogger(null);
        if (cfg != null && (ice4jPropertyNames = cfg.getPropertyNamesByPrefix("org.ice4j.", false)) != null && !ice4jPropertyNames.isEmpty()) {
            for (String propertyName : ice4jPropertyNames) {
                String propertyValue = cfg.getString(propertyName);
                if (propertyValue == null) continue;
                System.setProperty(propertyName, propertyValue);
            }
        }
        try {
            HostCandidateHarvester.initializeInterfaceFilters();
        }
        catch (Exception e) {
            logger.warn((Object)"There were errors during host candidate interface filters initialization.", (Throwable)e);
        }
        this.bundleContext = bundleContext;
    }

    void stop(BundleContext bundleContext) throws Exception {
        this.bundleContext = null;
    }

    static {
        logger = Logger.getLogger(Videobridge.class);
        RANDOM = new Random();
    }
}

