/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.SessionAddress;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.RTPLevelRelayType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RTPHdrExtPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.java.sip.communicator.util.ServiceUtils;
import org.ice4j.socket.DatagramPacketFilter;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.impl.neomedia.SSRCFactoryImpl;
import org.jitsi.impl.neomedia.rtp.translator.RTCPFeedbackMessageSender;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.transform.zrtp.ZrtpRawPacket;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.SSRCFactory;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.service.neomedia.recording.Recorder;
import org.jitsi.service.neomedia.recording.Synchronizer;
import org.jitsi.util.Logger;
import org.jitsi.util.event.WeakReferencePropertyChangeListener;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.ConferenceSpeechActivity;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.RtpChannelDatagramFilter;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.metrics.MetricService;
import org.jitsi.videobridge.xmpp.ComponentImpl;
import org.jivesoftware.smack.packet.IQ;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtpChannel
extends Channel
implements PropertyChangeListener {
    private static final String DISABLE_ABS_SEND_TIME_PNAME = "org.jitsi.videobridge.DISABLE_ABS_SEND_TIME";
    private static final Logger logger = Logger.getLogger(RtpChannel.class);
    private static final long[] NO_RECEIVE_SSRCS = new long[0];
    protected final ConferenceSpeechActivity conferenceSpeechActivity;
    private final RtpChannelDatagramFilter[] datagramFilters = new RtpChannelDatagramFilter[2];
    private final long initialLocalSSRC;
    private long lastKnownPacketsLostNB = 0L;
    private long lastKnownPacketsNB = 0L;
    private long lastKnownReceivedBytes = 0L;
    private long lastKnownSentBytes = 0L;
    private final PropertyChangeListener propertyChangeListener = new WeakReferencePropertyChangeListener((PropertyChangeListener)this);
    int[] receivePTs = new int[0];
    long[] receiveSSRCs = NO_RECEIVE_SSRCS;
    private RTPLevelRelayType rtpLevelRelayType;
    private MediaStream stream;
    private boolean streamClosed = false;
    private final PropertyChangeListener streamPropertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            RtpChannel.this.streamPropertyChange(ev);
        }
    };
    private final SessionAddress streamTarget = new SessionAddress();

    static RtpChannel getChannel(MediaStream stream) {
        return (RtpChannel)stream.getProperty(RtpChannel.class.getName());
    }

    public RtpChannel(Content content, String id, String channelBundleId, String transportNamespace, Boolean initiator) throws Exception {
        super(content, id, channelBundleId, transportNamespace, initiator);
        this.initialLocalSSRC = Videobridge.RANDOM.nextInt();
        this.conferenceSpeechActivity = this.getContent().getConference().getSpeechActivity();
        if (this.conferenceSpeechActivity != null) {
            this.conferenceSpeechActivity.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.touch();
    }

    private boolean acceptControlInputStreamDatagramPacket(DatagramPacket p) {
        boolean accept;
        InetAddress ctrlAddr = this.streamTarget.getControlAddress();
        int ctrlPort = this.streamTarget.getControlPort();
        if (ctrlAddr == null) {
            this.streamTarget.setControlHostAddress(p.getAddress());
            this.streamTarget.setControlPort(p.getPort());
            InetAddress dataAddr = this.streamTarget.getDataAddress();
            int dataPort = this.streamTarget.getDataPort();
            if (dataAddr != null) {
                ctrlAddr = this.streamTarget.getControlAddress();
                ctrlPort = this.streamTarget.getControlPort();
                this.stream.setTarget(new MediaStreamTarget(dataAddr, dataPort, ctrlAddr, ctrlPort));
            }
            accept = true;
        } else {
            boolean bl = accept = ctrlAddr.equals(p.getAddress()) && ctrlPort == p.getPort();
        }
        if (accept) {
            int ssrc;
            int sc;
            int offset;
            byte[] data;
            byte b0;
            this.touch();
            if (p.getLength() > 8 && ((b0 = (data = p.getData())[offset = p.getOffset()]) & 0xC0) >>> 6 == 2 && (data[offset + 1] & 0xFF) == 203 && (sc = b0 & 0x1F) > 0 && this.removeReceiveSSRC(ssrc = RTPTranslatorImpl.readInt((byte[])data, (int)(offset + 4)))) {
                this.notifyFocus();
            }
        }
        return accept;
    }

    protected boolean acceptDataInputStreamDatagramPacket(DatagramPacket p) {
        boolean accept;
        InetAddress dataAddr = this.streamTarget.getDataAddress();
        int dataPort = this.streamTarget.getDataPort();
        if (dataAddr == null) {
            this.streamTarget.setDataHostAddress(p.getAddress());
            this.streamTarget.setDataPort(p.getPort());
            dataAddr = this.streamTarget.getDataAddress();
            dataPort = this.streamTarget.getDataPort();
            InetAddress ctrlAddr = this.streamTarget.getControlAddress();
            int ctrlPort = this.streamTarget.getControlPort();
            MediaStreamTarget newStreamTarget = ctrlAddr == null ? new MediaStreamTarget(new InetSocketAddress(dataAddr, dataPort), null) : new MediaStreamTarget(dataAddr, dataPort, ctrlAddr, ctrlPort);
            this.stream.setTarget(newStreamTarget);
            accept = true;
        } else {
            boolean bl = accept = dataAddr.equals(p.getAddress()) && dataPort == p.getPort();
        }
        if (accept) {
            this.touch();
            if (p.getLength() >= 12) {
                int off;
                byte[] data = p.getData();
                int v = (data[off = p.getOffset()] & 0xC0) >>> 6;
                if (v == 0) {
                    byte[] zrtpMagicCookie;
                    if ((data[off] & 0x10) == 16 && data[off + 4] == (zrtpMagicCookie = ZrtpRawPacket.ZRTP_MAGIC)[0] && data[off + 5] == zrtpMagicCookie[1] && data[off + 6] == zrtpMagicCookie[2] && data[off + 7] == zrtpMagicCookie[3]) {
                        accept = false;
                    }
                } else if (v == 2) {
                    int pt;
                    MediaFormat format;
                    Map payloadTypes;
                    Synchronizer synchronizer;
                    Endpoint endpoint;
                    Recorder recorder;
                    int ssrc = RTPTranslatorImpl.readInt((byte[])data, (int)(off + 8));
                    boolean notify = this.addReceiveSSRC(ssrc);
                    if (notify && this.getContent().isRecording() && (recorder = this.getContent().getRecorder()) != null && (endpoint = this.getEndpoint()) != null && (synchronizer = recorder.getSynchronizer()) != null) {
                        synchronizer.setEndpoint((long)ssrc & 0xFFFFFFFFL, endpoint.getID());
                    }
                    if (RTPLevelRelayType.MIXER.equals((Object)this.getRTPLevelRelayType()) && (payloadTypes = this.stream.getDynamicRTPPayloadTypes()) != null && (format = (MediaFormat)payloadTypes.get((byte)(pt = data[off + 1] & 0x7F))) != null && !format.equals((Object)this.stream.getFormat())) {
                        this.stream.setFormat(format);
                        this.stream.setDirection(MediaDirection.SENDRECV);
                        notify = true;
                    }
                    if (notify) {
                        this.notifyFocus();
                    }
                }
            }
        }
        return accept;
    }

    private synchronized boolean addReceiveSSRC(int receiveSSRC) {
        long now = System.currentTimeMillis();
        int length = this.receiveSSRCs.length;
        for (int i = 0; i < length; i += 2) {
            if ((int)this.receiveSSRCs[i] != receiveSSRC) continue;
            this.receiveSSRCs[i + 1] = now;
            return false;
        }
        long[] newReceiveSSRCs = new long[length + 2];
        System.arraycopy(this.receiveSSRCs, 0, newReceiveSSRCs, 0, length);
        newReceiveSSRCs[length] = 0xFFFFFFFFL & (long)receiveSSRC;
        newReceiveSSRCs[length + 1] = now;
        this.receiveSSRCs = newReceiveSSRCs;
        return true;
    }

    void askForKeyframes() {
        int[] receiveSSRCs = this.getReceiveSSRCs();
        this.askForKeyframes(receiveSSRCs);
    }

    public void askForKeyframes(int[] receiveSSRCs) {
        RTCPFeedbackMessageSender rtcpFeedbackMessageSender;
        if (receiveSSRCs != null && receiveSSRCs.length != 0 && (rtcpFeedbackMessageSender = this.getContent().getRTCPFeedbackMessageSender()) != null) {
            rtcpFeedbackMessageSender.sendFIR(this.stream, receiveSSRCs);
        }
    }

    @Override
    protected void closeStream() {
        if (!this.streamClosed) {
            this.stream.setProperty(Channel.class.getName(), null);
            this.removeStreamListeners();
            this.stream.close();
            this.streamClosed = true;
        }
    }

    @Override
    public void describe(ColibriConferenceIQ.ChannelCommon commonIq) {
        ColibriConferenceIQ.Channel iq = (ColibriConferenceIQ.Channel)commonIq;
        iq.setRTPLevelRelayType(this.getRTPLevelRelayType());
        super.describe((ColibriConferenceIQ.ChannelCommon)iq);
        iq.setDirection(this.stream.getDirection());
        iq.setLastN(null);
        long initialLocalSSRC = this.getInitialLocalSSRC();
        if (initialLocalSSRC != -1L) {
            SourcePacketExtension source = new SourcePacketExtension();
            source.setSSRC(initialLocalSSRC);
            iq.addSource(source);
        }
        iq.setSSRCs(this.getReceiveSSRCs());
    }

    private void dominantSpeakerChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RtpChannelDatagramFilter getDatagramFilter(boolean rtcp) {
        int index = rtcp ? 1 : 0;
        RtpChannelDatagramFilter[] rtpChannelDatagramFilterArray = this.datagramFilters;
        synchronized (this.datagramFilters) {
            RtpChannelDatagramFilter datagramFilter = this.datagramFilters[index];
            if (datagramFilter == null) {
                this.datagramFilters[index] = datagramFilter = new RtpChannelDatagramFilter(this, rtcp);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return datagramFilter;
        }
    }

    private long getInitialLocalSSRC() {
        switch (this.getRTPLevelRelayType()) {
            case MIXER: {
                return this.initialLocalSSRC;
            }
            case TRANSLATOR: {
                return this.getContent().getInitialLocalSSRC();
            }
        }
        return -1L;
    }

    public long getLastPacketsLostNB() {
        long newPacketsLost = this.stream.getMediaStreamStats().getNbPacketsLost();
        long lastPacketsNB = newPacketsLost - this.lastKnownPacketsLostNB;
        if (lastPacketsNB < 0L) {
            return 0L;
        }
        this.lastKnownPacketsLostNB = newPacketsLost;
        return lastPacketsNB;
    }

    public long getLastPacketsNB() {
        long newPackets = this.stream.getMediaStreamStats().getNbPackets();
        long lastPacketsNB = newPackets - this.lastKnownPacketsNB;
        if (lastPacketsNB < 0L) {
            return 0L;
        }
        this.lastKnownPacketsNB = newPackets;
        return lastPacketsNB;
    }

    private MediaService getMediaService() {
        return this.getContent().getMediaService();
    }

    public long getNBReceivedBytes() {
        long bytes = 0L;
        long newBytes = this.stream.getMediaStreamStats().getNbReceivedBytes();
        if (newBytes > this.lastKnownReceivedBytes) {
            bytes += newBytes - this.lastKnownReceivedBytes;
            this.lastKnownReceivedBytes = newBytes;
        }
        return bytes;
    }

    public long getNBSentBytes() {
        long bytes = 0L;
        long newBytes = this.stream.getMediaStreamStats().getNbSentBytes();
        if (newBytes > this.lastKnownSentBytes) {
            bytes += newBytes - this.lastKnownSentBytes;
            this.lastKnownSentBytes = newBytes;
        }
        return bytes;
    }

    public synchronized int[] getReceiveSSRCs() {
        int length = this.receiveSSRCs.length;
        if (length == 0) {
            return ColibriConferenceIQ.NO_SSRCS;
        }
        int[] receiveSSRCs = new int[length / 2];
        int src = 0;
        int dst = 0;
        while (src < length) {
            receiveSSRCs[dst] = (int)this.receiveSSRCs[src];
            src += 2;
            ++dst;
        }
        return receiveSSRCs;
    }

    public RTPLevelRelayType getRTPLevelRelayType() {
        if (this.rtpLevelRelayType == null) {
            this.setRTPLevelRelayType(RTPLevelRelayType.TRANSLATOR);
        }
        return this.rtpLevelRelayType;
    }

    public MediaStream getStream() {
        return this.stream;
    }

    @Override
    public void initialize() throws IOException {
        super.initialize();
        MediaService mediaService = this.getMediaService();
        MediaType mediaType = this.getContent().getMediaType();
        this.stream = mediaService.createMediaStream(null, mediaType, (SrtpControl)this.getDtlsControl());
        this.stream.addPropertyChangeListener(this.streamPropertyChangeListener);
        this.stream.setName(this.getID());
        this.stream.setProperty(RtpChannel.class.getName(), (Object)this);
    }

    public boolean isInLastN(Channel channel) {
        return true;
    }

    @Override
    protected void maybeStartStream() throws IOException {
        StreamConnector connector = this.getStreamConnector();
        if (connector == null) {
            return;
        }
        this.stream.setConnector(connector);
        MediaStreamTarget streamTarget = this.createStreamTarget();
        if (streamTarget != null) {
            InetSocketAddress ctrlAddr;
            InetSocketAddress dataAddr = streamTarget.getDataAddress();
            if (dataAddr != null) {
                this.streamTarget.setDataHostAddress(dataAddr.getAddress());
                this.streamTarget.setDataPort(dataAddr.getPort());
            }
            if ((ctrlAddr = streamTarget.getControlAddress()) != null) {
                this.streamTarget.setControlHostAddress(ctrlAddr.getAddress());
                this.streamTarget.setControlPort(ctrlAddr.getPort());
            }
            if (dataAddr != null) {
                this.stream.setTarget(streamTarget);
            }
        }
        Content content = this.getContent();
        if (!this.stream.isStarted()) {
            if (RTPLevelRelayType.MIXER.equals((Object)this.getRTPLevelRelayType())) {
                this.stream.setSSRCFactory((SSRCFactory)new SSRCFactoryImpl(this.initialLocalSSRC));
            }
            this.stream.start();
            Videobridge videobridge = this.getContent().getConference().getVideobridge();
            MetricService metricService = videobridge.getMetricService();
            if (metricService != null && streamTarget != null) {
                metricService.publishStringMetric(this.getClass().getName() + " start", this.streamTarget.getDataAddress().getHostAddress());
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Direction of channel " + this.getID() + " of content " + content.getName() + " of conference " + content.getConference().getID() + " is " + this.stream.getDirection() + "."));
        }
        this.touch();
    }

    private void notifyFocus() {
        block6: {
            Content content = this.getContent();
            Conference conference = content.getConference();
            String focus = conference.getFocus();
            if (focus == null) {
                return;
            }
            Collection<ComponentImpl> components = conference.getVideobridge().getComponents();
            if (!components.isEmpty()) {
                try {
                    ColibriConferenceIQ conferenceIQ = new ColibriConferenceIQ();
                    conference.describeShallow(conferenceIQ);
                    ColibriConferenceIQ.Content contentIQ = conferenceIQ.getOrCreateContent(content.getName());
                    ColibriConferenceIQ.Channel channelIQ = new ColibriConferenceIQ.Channel();
                    this.describe((ColibriConferenceIQ.ChannelCommon)channelIQ);
                    contentIQ.addChannel(channelIQ);
                    conferenceIQ.setTo(focus);
                    conferenceIQ.setType(IQ.Type.SET);
                    for (ComponentImpl component : components) {
                        component.send((IQ)conferenceIQ);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(t instanceof ThreadDeath)) break block6;
                    throw (ThreadDeath)t;
                }
            }
        }
    }

    @Override
    protected void onEndpointChanged(Endpoint oldValue, Endpoint newValue) {
        super.onEndpointChanged(oldValue, newValue);
        if (oldValue != null) {
            oldValue.removeChannel(this);
            oldValue.removePropertyChangeListener(this);
        }
        if (newValue != null) {
            newValue.addChannel(this);
            newValue.addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName;
        Object source = ev.getSource();
        if (this.conferenceSpeechActivity == source && this.conferenceSpeechActivity != null && ConferenceSpeechActivity.DOMINANT_ENDPOINT_PROPERTY_NAME.equals(propertyName = ev.getPropertyName())) {
            this.dominantSpeakerChanged();
        }
    }

    private synchronized boolean removeReceiveSSRC(int receiveSSRC) {
        boolean removed;
        block4: {
            int length;
            block3: {
                length = this.receiveSSRCs.length;
                removed = false;
                if (length != 2) break block3;
                if ((int)this.receiveSSRCs[0] != receiveSSRC) break block4;
                this.receiveSSRCs = NO_RECEIVE_SSRCS;
                removed = true;
                break block4;
            }
            for (int i = 0; i < length; i += 2) {
                if ((int)this.receiveSSRCs[i] != receiveSSRC) continue;
                long[] newReceiveSSRCs = new long[length - 2];
                if (i != 0) {
                    System.arraycopy(this.receiveSSRCs, 0, newReceiveSSRCs, 0, i);
                }
                if (i != newReceiveSSRCs.length) {
                    System.arraycopy(this.receiveSSRCs, i + 2, newReceiveSSRCs, i, newReceiveSSRCs.length - i);
                }
                removed = true;
                break;
            }
        }
        return removed;
    }

    protected void removeStreamListeners() {
        block3: {
            try {
                this.stream.removePropertyChangeListener(this.streamPropertyChangeListener);
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (!(t instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)t;
            }
        }
    }

    protected void rtpLevelRelayTypeChanged(RTPLevelRelayType oldValue, RTPLevelRelayType newValue) {
    }

    boolean rtpTranslatorWillWrite(boolean data, byte[] buffer, int offset, int length, Channel source) {
        return true;
    }

    void sctpConnectionReady(Endpoint endpoint) {
    }

    public void setAdaptiveLastN(boolean adaptiveLastN) {
    }

    public void setAdaptiveSimulcast(boolean adaptiveSimulcast) {
    }

    public void setDirection(MediaDirection direction) {
        if (this.streamTarget.getDataAddress() != null) {
            this.stream.setDirection(direction);
        }
        this.touch();
    }

    public void setLastN(Integer lastN) {
    }

    public void setPayloadTypes(List<PayloadTypePacketExtension> payloadTypes) {
        MediaService mediaService;
        if (payloadTypes != null && payloadTypes.size() > 0 && (mediaService = this.getMediaService()) != null) {
            int payloadTypeCount = payloadTypes.size();
            this.receivePTs = new int[payloadTypeCount];
            for (int i = 0; i < payloadTypeCount; ++i) {
                PayloadTypePacketExtension payloadType = payloadTypes.get(i);
                this.receivePTs[i] = payloadType.getID();
                MediaFormat mediaFormat = JingleUtils.payloadTypeToMediaFormat((PayloadTypePacketExtension)payloadType, (MediaService)mediaService, null);
                if (mediaFormat == null) continue;
                this.stream.addDynamicRTPPayloadType((byte)payloadType.getID(), mediaFormat);
            }
        }
        this.touch();
    }

    public void setRtpHeaderExtensions(Collection<RTPHdrExtPacketExtension> rtpHeaderExtensions) {
        if (rtpHeaderExtensions != null && rtpHeaderExtensions.size() > 0) {
            for (RTPHdrExtPacketExtension rtpHdrExtPacketExtension : rtpHeaderExtensions) {
                this.addRtpHeaderExtension(rtpHdrExtPacketExtension);
            }
        }
    }

    protected void addRtpHeaderExtension(RTPHdrExtPacketExtension rtpHdrExtPacketExtension) {
        ConfigurationService cfg;
        URI uri = rtpHdrExtPacketExtension.getURI();
        if (uri == null) {
            logger.warn((Object)("Failed to add an RTP header extension with an invalid URI: " + rtpHdrExtPacketExtension.getAttribute("uri")));
            return;
        }
        Byte id = Byte.valueOf(rtpHdrExtPacketExtension.getID());
        if (id == null) {
            logger.warn((Object)("Failed to add an RTP header extension with an invalid ID: " + rtpHdrExtPacketExtension.getID()));
            return;
        }
        if ("http://www.webrtc.org/experiments/rtp-hdrext/abs-send-time".equals(uri.toString()) && (cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)this.getBundleContext(), ConfigurationService.class)) != null && cfg.getBoolean(DISABLE_ABS_SEND_TIME_PNAME, false)) {
            return;
        }
        MediaStream stream = this.getStream();
        if (stream != null) {
            stream.addRTPExtension(id.byteValue(), new RTPExtension(uri));
        }
    }

    public void setRTPLevelRelayType(RTPLevelRelayType rtpLevelRelayType) {
        if (rtpLevelRelayType == null) {
            throw new NullPointerException("rtpLevelRelayType");
        }
        if (this.rtpLevelRelayType == null) {
            RTPLevelRelayType oldValue = null;
            this.rtpLevelRelayType = rtpLevelRelayType;
            RTPLevelRelayType newValue = this.getRTPLevelRelayType();
            switch (newValue) {
                case MIXER: {
                    MediaDevice device = this.getContent().getMixer();
                    this.stream.setDevice(device);
                    if (this.stream.getFormat() != null) break;
                    this.stream.setDirection(MediaDirection.RECVONLY);
                    break;
                }
                case TRANSLATOR: {
                    this.stream.setRTPTranslator(this.getContent().getRTPTranslator());
                    break;
                }
                default: {
                    throw new IllegalStateException("rtpLevelRelayType");
                }
            }
            this.rtpLevelRelayTypeChanged(oldValue, newValue);
        } else if (!this.rtpLevelRelayType.equals((Object)rtpLevelRelayType)) {
            // empty if block
        }
        this.touch();
    }

    List<Endpoint> speechActivityEndpointsChanged(List<Endpoint> endpoints) {
        return null;
    }

    private void streamPropertyChange(PropertyChangeEvent ev) {
        String prefix;
        String propertyName = ev.getPropertyName();
        if (propertyName.startsWith(prefix = MediaStreamImpl.class.getName() + ".rtpConnector")) {
            Object datagramPacketFilter;
            String rtpConnectorPropertyName = propertyName.substring(prefix.length());
            Object newValue = ev.getNewValue();
            if (rtpConnectorPropertyName.equals("")) {
                if (newValue instanceof RTPConnector) {
                    this.streamRTPConnectorChanged((RTPConnector)ev.getOldValue(), (RTPConnector)newValue);
                }
            } else if (newValue instanceof RTPConnectorInputStream && (datagramPacketFilter = rtpConnectorPropertyName.equals(".controlInputStream") ? new DatagramPacketFilter(){

                public boolean accept(DatagramPacket p) {
                    return RtpChannel.this.acceptControlInputStreamDatagramPacket(p);
                }
            } : (rtpConnectorPropertyName.equals(".dataInputStream") ? new DatagramPacketFilter(){

                public boolean accept(DatagramPacket p) {
                    return RtpChannel.this.acceptDataInputStreamDatagramPacket(p);
                }
            } : null)) != null) {
                ((RTPConnectorInputStream)newValue).addDatagramPacketFilter(datagramPacketFilter);
            }
        }
    }

    protected void streamRTPConnectorChanged(RTPConnector oldValue, RTPConnector newValue) {
    }
}

