/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.ivffile;

import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jitsi.impl.neomedia.jmfext.media.protocol.ivffile.IVFFileReader;

public class IVFHeader {
    private String signature;
    private short version;
    private short headerLength;
    private String codec;
    private short width;
    private short height;
    private int framerate;
    private int timeScale;
    private int numberOfFramesInFile;

    public IVFHeader(String filePath) {
        try {
            FileInputStream input = new FileInputStream(filePath);
            DataInputStream stream = new DataInputStream(input);
            this.signature = "" + (char)stream.readByte() + (char)stream.readByte() + (char)stream.readByte() + (char)stream.readByte();
            this.version = IVFFileReader.changeEndianness(stream.readShort());
            this.headerLength = IVFFileReader.changeEndianness(stream.readShort());
            this.codec = "" + (char)stream.readByte() + (char)stream.readByte() + (char)stream.readByte() + (char)stream.readByte();
            this.width = IVFFileReader.changeEndianness(stream.readShort());
            this.height = IVFFileReader.changeEndianness(stream.readShort());
            this.framerate = IVFFileReader.changeEndianness(stream.readInt());
            this.timeScale = IVFFileReader.changeEndianness(stream.readInt());
            this.numberOfFramesInFile = IVFFileReader.changeEndianness(stream.readInt());
            stream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getSignature() {
        return this.signature;
    }

    public short getVersion() {
        return this.version;
    }

    public short getHeaderLength() {
        return this.headerLength;
    }

    public String getCodec() {
        return this.codec;
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public int getFramerate() {
        return this.framerate;
    }

    public int getTimeScale() {
        return this.timeScale;
    }

    public int getNumberOfFramesInFile() {
        return this.numberOfFramesInFile;
    }
}

