/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.net.DatagramPacket;
import org.ice4j.socket.DTLSDatagramFilter;
import org.ice4j.socket.DatagramPacketFilter;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.videobridge.RtpChannel;

class RtpChannelDatagramFilter
implements DatagramPacketFilter {
    private static final DatagramPacketFilter DTLS_DATAGRAM_FILTER = new DTLSDatagramFilter();
    private boolean acceptNonRtp = false;
    private final RtpChannel channel;
    private boolean checkRtcpSsrc = true;
    private boolean checkRtpPayloadType = true;
    private final boolean rtcp;

    RtpChannelDatagramFilter(RtpChannel channel, boolean rtcp) {
        this(channel, rtcp, false);
    }

    RtpChannelDatagramFilter(RtpChannel channel, boolean rtcp, boolean acceptNonRtp) {
        this.channel = channel;
        this.rtcp = rtcp;
        this.acceptNonRtp = acceptNonRtp;
    }

    public boolean accept(DatagramPacket p) {
        int off;
        byte[] data;
        int len = p.getLength();
        if (len >= 4 && ((data = p.getData())[(off = p.getOffset()) + 0] & 0xC0) >> 6 == 2) {
            int pt = data[off + 1] & 0xFF;
            if (200 <= pt && pt <= 211) {
                return this.rtcp && this.acceptRTCP(data, off, len);
            }
            return !this.rtcp && this.acceptRTP(pt & 0x7F);
        }
        return this.acceptNonRtp && DTLS_DATAGRAM_FILTER.accept(p);
    }

    private boolean acceptRTCP(byte[] data, int off, int len) {
        if (this.checkRtcpSsrc) {
            if (len >= 8) {
                long[] channelSSRCs;
                long packetSenderSSRC = (long)RTPTranslatorImpl.readInt((byte[])data, (int)(off + 4)) & 0xFFFFFFFFL;
                for (long channelSSRC : channelSSRCs = this.channel.receiveSSRCs) {
                    if (channelSSRC != packetSenderSSRC) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean acceptRTP(int pt) {
        if (this.checkRtpPayloadType) {
            int[] channelPTs;
            for (int channelPT : channelPTs = this.channel.receivePTs) {
                if (channelPT != pt) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void setAcceptNonRtp(boolean acceptNonRtp) {
        this.acceptNonRtp = acceptNonRtp;
    }

    public void setCheckRtcpSsrc(boolean checkRtcpSsrc) {
        this.checkRtcpSsrc = checkRtcpSsrc;
    }

    public void setCheckRtpPayloadType(boolean checkRtpPayloadType) {
        this.checkRtpPayloadType = checkRtpPayloadType;
    }
}

