/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ByteArraySerializer;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DefaultData;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerAdapter;
import java.io.IOException;

class ByteArraySerializerAdapter
implements SerializerAdapter {
    protected final ByteArraySerializer serializer;

    public ByteArraySerializerAdapter(ByteArraySerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public void write(ObjectDataOutput out, Object object) throws IOException {
        byte[] bytes = this.serializer.write(object);
        out.writeByteArray(bytes);
    }

    @Override
    public Object read(ObjectDataInput in) throws IOException {
        byte[] bytes = in.readByteArray();
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return this.serializer.read(bytes);
    }

    @Override
    public Data toData(Object object, int partitionHash) throws IOException {
        byte[] data = this.serializer.write(object);
        return new DefaultData(this.serializer.getTypeId(), data, partitionHash);
    }

    @Override
    public Object toObject(Data data) throws IOException {
        return this.serializer.read(data.getData());
    }

    @Override
    public int getTypeId() {
        return this.serializer.getTypeId();
    }

    @Override
    public void destroy() {
        this.serializer.destroy();
    }

    @Override
    public Serializer getImpl() {
        return this.serializer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SerializerAdapter{");
        sb.append("serializer=").append(this.serializer);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArraySerializerAdapter that = (ByteArraySerializerAdapter)o;
        return !(this.serializer != null ? !this.serializer.equals(that.serializer) : that.serializer != null);
    }

    public int hashCode() {
        return this.serializer != null ? this.serializer.hashCode() : 0;
    }
}

