/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.html;

import com.opensymphony.module.sitemesh.html.StateChangeListener;
import com.opensymphony.module.sitemesh.html.TagRule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class State {
    private final List rules = new ArrayList();
    private final ArrayList listeners = new ArrayList();

    public void addRule(TagRule rule) {
        this.rules.add(rule);
    }

    public boolean shouldProcessTag(String tagName) {
        Iterator iterator = this.rules.iterator();
        while (iterator.hasNext()) {
            TagRule tagRule = (TagRule)iterator.next();
            if (!tagRule.shouldProcess(tagName)) continue;
            return true;
        }
        return false;
    }

    public TagRule getRule(String tagName) {
        Iterator iterator = this.rules.iterator();
        while (iterator.hasNext()) {
            TagRule tagRule = (TagRule)iterator.next();
            if (!tagRule.shouldProcess(tagName)) continue;
            return tagRule;
        }
        return null;
    }

    public void addListener(StateChangeListener listener) {
        this.listeners.add(listener);
    }

    public void endOfState() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            StateChangeListener listener = (StateChangeListener)iter.next();
            listener.stateFinished();
        }
    }
}

