/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleExecutor {
    private int clientCount = 0;
    private ScheduledExecutorService executor;

    public <T> Future<T> submit(Callable<T> callable) {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
        }
        return this.executor.submit(callable);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
        }
        return this.executor.scheduleWithFixedDelay(runnable, l, l2, timeUnit);
    }

    public <T> ScheduledFuture<T> schedule(Callable<T> callable, long l, TimeUnit timeUnit) {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
        }
        return this.executor.schedule(callable, l, timeUnit);
    }

    private void dispose() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    public void increaseClient() {
        ++this.clientCount;
    }

    public void decreaseClient() {
        --this.clientCount;
        if (this.clientCount <= 0) {
            this.dispose();
        }
    }
}

