/*
 * Decompiled with CFR 0.152.
 */
package org.jugbb.ant.jws;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JNLPTask
extends Task {
    private String jnlpFileName;
    private String jnlpVersion = "6.0+";
    private String codebase;
    private String title;
    private String vendor;
    private String homepage;
    private String iconHref;
    private String offlineAllowed = "true";
    private String description;
    private String createDesktopShortcut;
    private String createMenuEntry;
    private String subMenuName;
    private String associateWithFileExtensions;
    private String associateWithMimeType;
    private String updateCheck = "timeout";
    private String updatePolicy = "always";
    private String javaVersion = "1.6+";
    private String javaMaxHeapSize;
    private String folderWithSignedJars;
    private String mainClass;
    private String applicationArguments;
    private String mainJarFile;

    public String getMainJarFile() {
        return this.mainJarFile;
    }

    public void setMainJarFile(String mainJarFile) {
        this.mainJarFile = mainJarFile;
    }

    public String getJnlpFileName() {
        return this.jnlpFileName;
    }

    public void setJnlpFileName(String jnlpFileName) {
        this.jnlpFileName = jnlpFileName;
    }

    public String getJnlpVersion() {
        return this.jnlpVersion;
    }

    public void setJnlpVersion(String jnlpVersion) {
        this.jnlpVersion = jnlpVersion;
    }

    public String getCodebase() {
        return this.codebase;
    }

    public void setCodebase(String codebase) {
        this.codebase = codebase;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String titel) {
        this.title = titel;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public String getIconHref() {
        return this.iconHref;
    }

    public void setIconHref(String iconHref) {
        this.iconHref = iconHref;
    }

    public String getOfflineAllowed() {
        return this.offlineAllowed;
    }

    public void setOfflineAllowed(String offlineAllowed) {
        this.offlineAllowed = offlineAllowed;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreateDesktopShortcut() {
        return this.createDesktopShortcut;
    }

    public void setCreateDesktopShortcut(String createDesktopShortcut) {
        this.createDesktopShortcut = createDesktopShortcut;
    }

    public String getCreateMenuEntry() {
        return this.createMenuEntry;
    }

    public void setCreateMenuEntry(String createMenuEntry) {
        this.createMenuEntry = createMenuEntry;
    }

    public String getSubMenuName() {
        return this.subMenuName;
    }

    public void setSubMenuName(String subMenuName) {
        this.subMenuName = subMenuName;
    }

    public String getAssociateWithFileExtensions() {
        return this.associateWithFileExtensions;
    }

    public void setAssociateWithFileExtensions(String associateWithFileExtension) {
        this.associateWithFileExtensions = associateWithFileExtension;
    }

    public String getAssociateWithMimeType() {
        return this.associateWithMimeType;
    }

    public void setAssociateWithMimeType(String associateWithMimeType) {
        this.associateWithMimeType = associateWithMimeType;
    }

    public String getUpdateCheck() {
        return this.updateCheck;
    }

    public void setUpdateCheck(String updateCheck) {
        this.updateCheck = updateCheck;
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setUpdatePolicy(String updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public String getJavaMaxHeapSize() {
        return this.javaMaxHeapSize;
    }

    public void setJavaMaxHeapSize(String javaMaxHeapSize) {
        this.javaMaxHeapSize = javaMaxHeapSize;
    }

    public String getFolderWithSignedJars() {
        return this.folderWithSignedJars;
    }

    public void setFolderWithSignedJars(String folderWithSignedJars) {
        this.folderWithSignedJars = folderWithSignedJars;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getApplicationArguments() {
        return this.applicationArguments;
    }

    public void setApplicationArguments(String applicationArguments) {
        this.applicationArguments = applicationArguments;
    }

    public void execute() throws BuildException {
        if (this.title == null) {
            throw new BuildException("Attribute title cannot be null");
        }
        if (this.codebase == null) {
            throw new BuildException("Attribute codebase cannot be null");
        }
        if (this.folderWithSignedJars == null) {
            throw new BuildException("Attribute folderWithSignedJars cannot be null");
        }
        if (this.jnlpFileName == null) {
            throw new BuildException("Attribute jnlpFileName cannot be null");
        }
        File baseDir = new File(this.folderWithSignedJars);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            throw new BuildException("folderWithSignedJars must exists and must be a directory");
        }
        File jnlpFile = new File(this.folderWithSignedJars, this.jnlpFileName);
        this.log("create jnlp file: " + jnlpFile.getAbsolutePath() + " with codebase: " + this.codebase);
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jnlpFile, false), "UTF-8"));
            this.writeJNLP(writer);
        }
        catch (IOException e) {
            throw new BuildException("write jnlp file failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    throw new BuildException("close jnlp file failed: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void writeJNLP(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        writer.write("<jnlp spec=\"");
        writer.write(this.jnlpVersion);
        writer.write("\" codebase=\"");
        writer.write(this.codebase);
        writer.write("\" href=\"");
        writer.write(this.jnlpFileName);
        writer.write("\">\n\n");
        this.writeInformation(writer);
        this.writeUpdate(writer);
        this.writeSecurity(writer);
        this.writeResources(writer);
        this.writeApplicationDesc(writer);
        writer.write("</jnlp>");
    }

    private void writeInformation(Writer writer) throws IOException {
        writer.write("<information>\n");
        writer.write("<title>" + this.title + "</title>\n");
        writer.write("<vendor>" + this.vendor + "</vendor>\n");
        if (this.homepage != null) {
            writer.write("<homepage href=\"" + this.homepage + "\"/>\n");
        }
        writer.write("<description kind=\"short\">" + this.description + "</description>\n");
        writer.write("<icon href=\"" + this.iconHref + "\"/>\n");
        if (Boolean.parseBoolean(this.offlineAllowed)) {
            writer.write("<offline-allowed/>\n");
        }
        if (this.associateWithFileExtensions != null || this.associateWithMimeType != null) {
            writer.write("<association");
            if (this.associateWithMimeType != null) {
                writer.write(" mime-type=\"" + this.associateWithMimeType + "\"");
            }
            if (this.associateWithFileExtensions != null) {
                writer.write(" extensions=\"" + this.associateWithFileExtensions + "\"");
            }
            writer.write(" />\n");
        }
        boolean createDesktopShortCut = Boolean.parseBoolean(this.createDesktopShortcut);
        boolean createMenuEntry = Boolean.parseBoolean(this.createMenuEntry);
        if (createDesktopShortCut || createMenuEntry) {
            writer.write("<shortcut online=\"true\">\n");
            if (createDesktopShortCut) {
                writer.write("<desktop/>\n");
            }
            if (createMenuEntry) {
                if (this.subMenuName != null) {
                    writer.write("<menu submenu=\"" + this.subMenuName + "\"/>\n");
                } else {
                    writer.write("<menu/>\n");
                }
            }
            writer.write("</shortcut>\n");
        }
        writer.write("</information>\n\n");
    }

    private void writeUpdate(Writer writer) throws IOException {
        writer.write("<update check=\"" + this.updateCheck + "\" policy=\"" + this.updatePolicy + "\" />\n\n");
    }

    private void writeSecurity(Writer writer) throws IOException {
        writer.write("<security>\n");
        writer.write("<all-permissions/>\n");
        writer.write("</security>\n\n");
    }

    private void writeResources(Writer writer) throws IOException {
        writer.write("<resources>\n");
        writer.write("<j2se version=\"" + this.javaVersion + "\"");
        if (this.javaMaxHeapSize != null) {
            writer.write(" max-heap-size=\"" + this.javaMaxHeapSize + "\"");
        }
        writer.write("/>\n");
        File baseDir = new File(this.folderWithSignedJars);
        File[] jars = baseDir.listFiles();
        boolean jarsAdded = false;
        if (jars != null && jars.length > 0) {
            for (File jarFile : jars) {
                if (!jarFile.getName().toLowerCase().endsWith(".jar")) continue;
                writer.write("<jar href=\"" + jarFile.getName() + "\" " + (this.isMainJarFile(jarFile) ? "main=\"true\"" : "") + "/>\n");
                jarsAdded = true;
            }
        }
        if (!jarsAdded) {
            throw new BuildException("There are no jar-files to add as resource");
        }
        writer.write("</resources>\n\n");
    }

    private boolean isMainJarFile(File jarFile) {
        if (this.mainJarFile != null) {
            return this.mainJarFile.equalsIgnoreCase(jarFile.getName());
        }
        return false;
    }

    private void writeApplicationDesc(Writer writer) throws IOException {
        writer.write("<application-desc main-class=\"" + this.mainClass + "\">\n");
        if (this.applicationArguments != null) {
            StringTokenizer st = new StringTokenizer(this.applicationArguments, " ");
            while (st.hasMoreTokens()) {
                writer.write("<argument>" + st.nextToken() + "</argument>\n");
            }
        }
        writer.write("</application-desc>\n\n");
    }
}

