/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.CapabilityBlock;

public class ShortCapabilityBlock
implements Writable {
    private static final byte[] BLOCK_DEFAULT = new byte[]{9, 70, 0, 0, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0};
    private static final ByteBlock BYTEBLOCK_DEFAULT = ByteBlock.wrap(BLOCK_DEFAULT);
    private final ByteBlock data;

    public static ShortCapabilityBlock[] readShortCaps(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        LinkedList<ShortCapabilityBlock> linkedList = new LinkedList<ShortCapabilityBlock>();
        for (int i = 0; i < byteBlock.getLength(); i += 2) {
            linkedList.add(new ShortCapabilityBlock(byteBlock.subBlock(i, 2)));
        }
        return linkedList.toArray(new ShortCapabilityBlock[0]);
    }

    public static boolean couldBeShortBlock(CapabilityBlock capabilityBlock) {
        DefensiveTools.checkNull(capabilityBlock, "cap");
        ByteBlock byteBlock = capabilityBlock.getBlock();
        return byteBlock.subBlock(0, 2).equals(BYTEBLOCK_DEFAULT.subBlock(0, 2)) && byteBlock.subBlock(4).equals(BYTEBLOCK_DEFAULT.subBlock(4));
    }

    public static ShortCapabilityBlock getShortBlock(CapabilityBlock capabilityBlock) throws IllegalArgumentException {
        DefensiveTools.checkNull(capabilityBlock, "cap");
        if (!ShortCapabilityBlock.couldBeShortBlock(capabilityBlock)) {
            throw new IllegalArgumentException("Capability block '" + capabilityBlock + "' cannot be converted to a short capability block");
        }
        return new ShortCapabilityBlock(capabilityBlock.getBlock().subBlock(2, 2));
    }

    public ShortCapabilityBlock(ByteBlock byteBlock) throws IllegalArgumentException {
        DefensiveTools.checkNull(byteBlock, "data");
        if (byteBlock.getLength() != 2) {
            throw new IllegalArgumentException("short capability data block must contain only two bytes (it has " + byteBlock.getLength() + ")");
        }
        this.data = byteBlock;
    }

    public final ByteBlock getData() {
        return this.data;
    }

    public final CapabilityBlock toCapabilityBlock() {
        byte[] byArray = (byte[])BLOCK_DEFAULT.clone();
        System.arraycopy(this.data.toByteArray(), 0, byArray, 2, 2);
        return new CapabilityBlock(ByteBlock.wrap(byArray));
    }

    public long getWritableLength() {
        return 2L;
    }

    public void write(OutputStream outputStream) throws IOException {
        this.data.write(outputStream);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShortCapabilityBlock)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ShortCapabilityBlock shortCapabilityBlock = (ShortCapabilityBlock)object;
        return shortCapabilityBlock.data.equals(this.data);
    }

    public int hashCode() {
        return BinaryTools.getUShort(this.data, 0);
    }

    public String toString() {
        return "ShortCapabilityBlock: " + BinaryTools.describeData(this.data);
    }
}

