/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.monitor.impl.LocalReplicatedMapStatsImpl;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.impl.ReplicatedMapProxy;
import com.hazelcast.replicatedmap.impl.ReplicatedMessageListener;
import com.hazelcast.replicatedmap.impl.messages.MultiReplicationMessage;
import com.hazelcast.replicatedmap.impl.messages.ReplicationMessage;
import com.hazelcast.replicatedmap.impl.record.AbstractReplicatedRecordStore;
import com.hazelcast.replicatedmap.impl.record.DataReplicatedRecordStore;
import com.hazelcast.replicatedmap.impl.record.ObjectReplicatedRecordStorage;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.replicatedmap.impl.record.ReplicationPublisher;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.EventListener;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class ReplicatedMapService
implements ManagedService,
RemoteService,
EventPublishingService<Object, Object> {
    public static final String SERVICE_NAME = "hz:impl:replicatedMapService";
    public static final String EVENT_TOPIC_NAME = "hz:impl:replicatedMapService.replication";
    private final ConcurrentHashMap<String, ReplicatedRecordStore> replicatedStorages = this.initReplicatedRecordStoreMapping();
    private final ConstructorFunction<String, ReplicatedRecordStore> constructor = this.buildConstructorFunction();
    private final Config config;
    private final NodeEngine nodeEngine;
    private final EventService eventService;
    private final EventRegistration eventRegistration;

    public ReplicatedMapService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.config = nodeEngine.getConfig();
        this.eventService = nodeEngine.getEventService();
        this.eventRegistration = this.eventService.registerListener(SERVICE_NAME, EVENT_TOPIC_NAME, new ReplicationListener());
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    @Override
    public void reset() {
        for (ReplicatedRecordStore replicatedRecordStore : this.replicatedStorages.values()) {
            replicatedRecordStore.clear(false, true);
        }
    }

    @Override
    public void shutdown(boolean terminate) {
        for (ReplicatedRecordStore replicatedRecordStore : this.replicatedStorages.values()) {
            replicatedRecordStore.destroy();
        }
        this.replicatedStorages.clear();
    }

    @Override
    public DistributedObject createDistributedObject(String objectName) {
        ReplicatedRecordStore replicatedRecordStore = ConcurrencyUtil.getOrPutSynchronized(this.replicatedStorages, objectName, this.replicatedStorages, this.constructor);
        return new ReplicatedMapProxy(this.nodeEngine, (AbstractReplicatedRecordStore)replicatedRecordStore);
    }

    @Override
    public void destroyDistributedObject(String objectName) {
        ReplicatedRecordStore replicatedRecordStore = this.replicatedStorages.remove(objectName);
        if (replicatedRecordStore != null) {
            replicatedRecordStore.destroy();
        }
    }

    @Override
    public void dispatchEvent(Object event, Object listener) {
        if (event instanceof EntryEvent) {
            ReplicatedRecordStore recordStore;
            EntryEvent entryEvent = (EntryEvent)event;
            EntryListener entryListener = (EntryListener)listener;
            switch (entryEvent.getEventType()) {
                case ADDED: {
                    entryListener.entryAdded(entryEvent);
                    break;
                }
                case EVICTED: {
                    entryListener.entryEvicted(entryEvent);
                    break;
                }
                case UPDATED: {
                    entryListener.entryUpdated(entryEvent);
                    break;
                }
                case REMOVED: {
                    entryListener.entryRemoved(entryEvent);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("event type " + (Object)((Object)entryEvent.getEventType()) + " not supported");
                }
            }
            String mapName = ((EntryEvent)event).getName();
            if (this.config.findReplicatedMapConfig(mapName).isStatisticsEnabled() && (recordStore = this.replicatedStorages.get(mapName)) instanceof AbstractReplicatedRecordStore) {
                LocalReplicatedMapStatsImpl stats = ((AbstractReplicatedRecordStore)recordStore).getReplicatedMapStats();
                stats.incrementReceivedEvents();
            }
        } else if (listener instanceof ReplicatedMessageListener) {
            ((ReplicatedMessageListener)listener).onMessage((IdentifiedDataSerializable)event);
        }
    }

    public ReplicatedMapConfig getReplicatedMapConfig(String name) {
        return this.config.getReplicatedMapConfig(name).getAsReadOnly();
    }

    public ReplicatedRecordStore getReplicatedRecordStore(String name, boolean create) {
        if (create) {
            return ConcurrencyUtil.getOrPutSynchronized(this.replicatedStorages, name, this.replicatedStorages, this.constructor);
        }
        return this.replicatedStorages.get(name);
    }

    public String addEventListener(EventListener entryListener, EventFilter eventFilter, String mapName) {
        EventRegistration registration = this.eventService.registerLocalListener(SERVICE_NAME, mapName, eventFilter, entryListener);
        return registration.getId();
    }

    public boolean removeEventListener(String mapName, String registrationId) {
        return this.eventService.deregisterListener(SERVICE_NAME, mapName, registrationId);
    }

    private ConcurrentHashMap<String, ReplicatedRecordStore> initReplicatedRecordStoreMapping() {
        return new ConcurrentHashMap<String, ReplicatedRecordStore>();
    }

    private ConstructorFunction<String, ReplicatedRecordStore> buildConstructorFunction() {
        return new ConstructorFunction<String, ReplicatedRecordStore>(){

            @Override
            public ReplicatedRecordStore createNew(String name) {
                ReplicatedMapConfig replicatedMapConfig = ReplicatedMapService.this.getReplicatedMapConfig(name);
                InMemoryFormat inMemoryFormat = replicatedMapConfig.getInMemoryFormat();
                AbstractReplicatedRecordStore replicatedRecordStorage = null;
                switch (inMemoryFormat) {
                    case OBJECT: {
                        replicatedRecordStorage = new ObjectReplicatedRecordStorage(name, ReplicatedMapService.this.nodeEngine, ReplicatedMapService.this);
                        break;
                    }
                    case BINARY: {
                        replicatedRecordStorage = new DataReplicatedRecordStore(name, ReplicatedMapService.this.nodeEngine, ReplicatedMapService.this);
                        break;
                    }
                    case OFFHEAP: {
                        throw new IllegalStateException("offheap not yet supported for replicated map");
                    }
                    default: {
                        throw new IllegalStateException("Unhandeled in memory format:" + (Object)((Object)inMemoryFormat));
                    }
                }
                return replicatedRecordStorage;
            }
        };
    }

    private final class ReplicationListener
    implements ReplicatedMessageListener {
        private ReplicationListener() {
        }

        @Override
        public void onMessage(IdentifiedDataSerializable message) {
            if (message instanceof ReplicationMessage) {
                ReplicationMessage replicationMessage = (ReplicationMessage)message;
                ReplicatedRecordStore replicatedRecordStorage = (ReplicatedRecordStore)ReplicatedMapService.this.replicatedStorages.get(replicationMessage.getName());
                ReplicationPublisher replicationPublisher = replicatedRecordStorage.getReplicationPublisher();
                if (replicatedRecordStorage instanceof AbstractReplicatedRecordStore) {
                    replicationPublisher.queueUpdateMessage(replicationMessage);
                }
            } else if (message instanceof MultiReplicationMessage) {
                MultiReplicationMessage multiReplicationMessage = (MultiReplicationMessage)message;
                ReplicatedRecordStore replicatedRecordStorage = (ReplicatedRecordStore)ReplicatedMapService.this.replicatedStorages.get(multiReplicationMessage.getName());
                ReplicationPublisher replicationPublisher = replicatedRecordStorage.getReplicationPublisher();
                if (replicatedRecordStorage instanceof AbstractReplicatedRecordStore) {
                    replicationPublisher.queueUpdateMessages(multiReplicationMessage);
                }
            }
        }
    }
}

