/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractJoiner;
import com.hazelcast.cluster.JoinMessage;
import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.cluster.MulticastListener;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Address;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.RandomPicker;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MulticastJoiner
extends AbstractJoiner {
    private static final int PUBLISH_INTERVAL = 100;
    private static final long JOIN_RETRY_INTERVAL = 1000L;
    private final AtomicInteger currentTryCount = new AtomicInteger(0);
    private final AtomicInteger maxTryCount = new AtomicInteger(this.calculateTryCount());

    public MulticastJoiner(Node node) {
        super(node);
    }

    @Override
    public void doJoin() {
        long joinStartTime = Clock.currentTimeMillis();
        long maxJoinMillis = this.getMaxJoinMillis();
        Address thisAddress = this.node.getThisAddress();
        while (this.node.isActive() && !this.node.joined() && Clock.currentTimeMillis() - joinStartTime < maxJoinMillis) {
            this.node.setMasterAddress(null);
            Address masterAddress = this.getTargetAddress();
            if (masterAddress == null) {
                masterAddress = this.findMasterWithMulticast();
            }
            this.node.setMasterAddress(masterAddress);
            if (masterAddress == null || thisAddress.equals(masterAddress)) {
                this.node.setAsMaster();
                return;
            }
            this.logger.info("Trying to join to discovered node: " + masterAddress);
            this.joinMaster();
        }
    }

    private void joinMaster() {
        Address master;
        long maxMasterJoinTime = this.getMaxJoinTimeToMasterNode();
        long start = Clock.currentTimeMillis();
        while (this.node.isActive() && !this.node.joined() && Clock.currentTimeMillis() - start < maxMasterJoinTime && (master = this.node.getMasterAddress()) != null) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Joining to master " + master);
            }
            this.node.clusterService.sendJoinRequest(master, true);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                EmptyStatement.ignore(e);
            }
            if (!this.isBlacklisted(master)) continue;
            this.node.setMasterAddress(null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void searchForOtherClusters() {
        final LinkedBlockingQueue q = new LinkedBlockingQueue();
        MulticastListener listener = new MulticastListener(){

            @Override
            public void onMessage(Object msg) {
                if (msg != null && msg instanceof JoinMessage) {
                    JoinMessage joinRequest = (JoinMessage)msg;
                    if (MulticastJoiner.this.node.getThisAddress() != null && !MulticastJoiner.this.node.getThisAddress().equals(joinRequest.getAddress())) {
                        q.add(joinRequest);
                    }
                }
            }
        };
        this.node.multicastService.addMulticastListener(listener);
        this.node.multicastService.send(this.node.createJoinRequest());
        try {
            JoinMessage joinInfo = (JoinMessage)q.poll(3L, TimeUnit.SECONDS);
            if (joinInfo != null) {
                if (joinInfo.getMemberCount() == 1) {
                    Thread.sleep((long)this.node.groupProperties.WAIT_SECONDS_BEFORE_JOIN.getInteger() * 1000L * 2L);
                }
                if (this.shouldMerge(joinInfo)) {
                    this.logger.warning(this.node.getThisAddress() + " is merging [multicast] to " + joinInfo.getAddress());
                    this.startClusterMerge(joinInfo.getAddress());
                }
            }
        }
        catch (InterruptedException ignored) {
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.warning(e);
            }
        }
        finally {
            this.node.multicastService.removeMulticastListener(listener);
        }
    }

    @Override
    public String getType() {
        return "multicast";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address findMasterWithMulticast() {
        try {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Searching for master node. Max tries: " + this.maxTryCount.get());
            }
            JoinRequest joinRequest = this.node.createJoinRequest();
            while (this.node.isActive() && this.currentTryCount.incrementAndGet() <= this.maxTryCount.get()) {
                joinRequest.setTryCount(this.currentTryCount.get());
                this.node.multicastService.send(joinRequest);
                if (this.node.getMasterAddress() == null) {
                    Thread.sleep(100L);
                    continue;
                }
                Address address = this.node.getMasterAddress();
                return address;
            }
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.warning(e);
            }
        }
        finally {
            this.currentTryCount.set(0);
        }
        return null;
    }

    private int calculateTryCount() {
        int lastDigits;
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        int timeoutSeconds = networkConfig.getJoin().getMulticastConfig().getMulticastTimeoutSeconds();
        int tryCountCoefficient = 10;
        int tryCount = timeoutSeconds * tryCountCoefficient;
        String host = this.node.getThisAddress().getHost();
        try {
            lastDigits = Integer.parseInt(host.substring(host.lastIndexOf(46) + 1));
        }
        catch (NumberFormatException e) {
            lastDigits = RandomPicker.getInt(512);
        }
        int portDiff = this.node.getThisAddress().getPort() - networkConfig.getPort();
        return tryCount += (lastDigits %= 100) + portDiff * timeoutSeconds * 3;
    }

    public void onReceivedJoinRequest(JoinRequest joinRequest) {
        if (joinRequest.getUuid().compareTo(this.node.localMember.getUuid()) < 0) {
            this.maxTryCount.incrementAndGet();
        }
    }
}

