/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.CacheDistributedObject;
import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.HazelcastCacheManager;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.cache.impl.operation.CacheCreateConfigOperation;
import com.hazelcast.cache.impl.operation.CacheGetConfigOperation;
import com.hazelcast.cache.impl.operation.CacheManagementConfigOperation;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.FutureUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HazelcastServerCacheManager
extends HazelcastCacheManager {
    private NodeEngine nodeEngine;
    private CacheService cacheService;

    public HazelcastServerCacheManager(HazelcastServerCachingProvider cachingProvider, HazelcastInstance hazelcastInstance, URI uri, ClassLoader classLoader, Properties properties) {
        super(cachingProvider, uri, classLoader, properties);
        if (hazelcastInstance == null) {
            throw new NullPointerException("hazelcastInstance missing");
        }
        this.hazelcastInstance = hazelcastInstance;
        CacheDistributedObject setupRef = (CacheDistributedObject)hazelcastInstance.getDistributedObject("hz:impl:cacheService", "setupRef");
        this.nodeEngine = setupRef.getNodeEngine();
        this.cacheService = (CacheService)setupRef.getService();
        this.logger = this.nodeEngine.getLogger(this.getClass());
    }

    public void enableManagement(String cacheName, boolean enabled) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException();
        }
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        this.cacheService.enableManagement(cacheNameWithPrefix, enabled);
        this.enableStatisticManagementOnOtherNodes(cacheName, false, enabled);
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException();
        }
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        this.cacheService.enableStatistics(cacheNameWithPrefix, enabled);
        this.enableStatisticManagementOnOtherNodes(cacheName, true, enabled);
    }

    private void enableStatisticManagementOnOtherNodes(String cacheName, boolean statOrMan, boolean enabled) {
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        ArrayList<Future> futures = new ArrayList<Future>();
        for (MemberImpl member : members) {
            if (member.localMember()) continue;
            CacheManagementConfigOperation op = new CacheManagementConfigOperation(cacheNameWithPrefix, statOrMan, enabled);
            InternalCompletableFuture future = this.nodeEngine.getOperationService().invokeOnTarget("hz:impl:cacheService", op, member.getAddress());
            futures.add(future);
        }
        try {
            FutureUtil.waitWithDeadline(futures, 60L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.logger.warning(e);
        }
    }

    @Override
    protected <K, V> CacheConfig<K, V> getCacheConfigLocal(String cacheName) {
        return this.cacheService.getCacheConfig(cacheName);
    }

    @Override
    protected <K, V> boolean createConfigOnPartition(CacheConfig<K, V> cacheConfig) {
        CacheCreateConfigOperation cacheCreateConfigOperation = new CacheCreateConfigOperation(cacheConfig);
        OperationService operationService = this.nodeEngine.getOperationService();
        int partitionId = this.nodeEngine.getPartitionService().getPartitionId(cacheConfig.getNameWithPrefix());
        InternalCompletableFuture f = operationService.invokeOnPartition("hz:impl:cacheService", cacheCreateConfigOperation, partitionId);
        return (Boolean)f.getSafely();
    }

    @Override
    protected <K, V> void addCacheConfigIfAbsentToLocal(CacheConfig<K, V> cacheConfig) {
        this.cacheService.createCacheConfigIfAbsent(cacheConfig, false);
    }

    @Override
    protected <K, V> ICache<K, V> createCacheProxy(CacheConfig<K, V> cacheConfig) {
        return new CacheProxy(cacheConfig, this.nodeEngine, this.cacheService, this);
    }

    @Override
    protected <K, V> CacheConfig<K, V> getCacheConfigFromPartition(String cacheNameWithPrefix) {
        CacheGetConfigOperation op = new CacheGetConfigOperation(cacheNameWithPrefix);
        int partitionId = this.nodeEngine.getPartitionService().getPartitionId(cacheNameWithPrefix);
        InternalCompletableFuture f = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:cacheService", op, partitionId);
        return (CacheConfig)f.getSafely();
    }
}

