/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.util.Enumeration;
import java.util.Vector;
import pl.mn.communicator.IChat;
import pl.mn.communicator.IIncommingMessage;
import pl.mn.communicator.MessageStatus;
import pl.mn.communicator.Session;
import pl.mn.communicator.event.MessageListener;

public abstract class AbstractChat
implements IChat {
    protected Vector m_listeners = new Vector();
    protected Session m_session = null;

    protected AbstractChat(Session session) {
        if (session == null) {
            throw new NullPointerException("session cannot be null");
        }
        this.m_session = session;
        session.getMessageService().addMessageListener(new MessageHandler());
    }

    public void addChatListener(MessageListener messageListener) {
        if (messageListener == null) {
            throw new NullPointerException("messageListener cannot be null");
        }
        this.m_listeners.add(messageListener);
    }

    public void removeChatListener(MessageListener messageListener) {
        if (messageListener == null) {
            throw new NullPointerException("messageListener cannot be null");
        }
        this.m_listeners.remove(messageListener);
    }

    protected void fireChatMessageArrived(IIncommingMessage message) {
        Enumeration e = this.m_listeners.elements();
        while (e.hasMoreElements()) {
            MessageListener listener = (MessageListener)e.nextElement();
            listener.messageArrived(message);
        }
    }

    protected void fireChatMessageDelivered(int uin, int messageID, MessageStatus deliveryStatus) {
        Enumeration e = this.m_listeners.elements();
        while (e.hasMoreElements()) {
            MessageListener listener = (MessageListener)e.nextElement();
            listener.messageDelivered(uin, messageID, deliveryStatus);
        }
    }

    protected abstract boolean acceptsIncoming(IIncommingMessage var1);

    protected abstract boolean acceptsOutgoing(int var1, int var2, MessageStatus var3);

    private class MessageHandler
    extends MessageListener.Stub {
        private MessageHandler() {
        }

        public void messageArrived(IIncommingMessage incommingMessage) {
            if (AbstractChat.this.acceptsIncoming(incommingMessage)) {
                AbstractChat.this.fireChatMessageArrived(incommingMessage);
            }
        }

        public void messageDelivered(int uin, int messageID, MessageStatus deliveryStatus) {
            if (AbstractChat.this.acceptsOutgoing(uin, messageID, deliveryStatus)) {
                AbstractChat.this.fireChatMessageDelivered(uin, messageID, deliveryStatus);
            }
        }
    }
}

