/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MinimalEncoder;
import net.kano.joscar.OscarTools;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.loc.LocCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetInterestsCmd
extends LocCommand {
    private static final int TYPE_CHARSET = 28;
    private static final int TYPE_INTEREST = 11;
    private final List<String> interests;

    protected SetInterestsCmd(SnacPacket packet) {
        super(15);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        ImmutableTlvChain chain = TlvTools.readChain(snacData);
        String charset = chain.getString(28);
        List<Tlv> interestTlvs = chain.getTlvs(11);
        ArrayList<String> interestList = new ArrayList<String>();
        for (Tlv interestTlv : interestTlvs) {
            ByteBlock interestBytes = interestTlv.getData();
            String interest = OscarTools.getString(interestBytes, charset);
            interestList.add(interest);
        }
        this.interests = Collections.unmodifiableList(interestList);
    }

    public SetInterestsCmd(List<String> interests) {
        super(15);
        this.interests = DefensiveTools.getUnmodifiableCopy(interests);
    }

    public final List<String> getInterests() {
        return this.interests;
    }

    @Override
    public void writeData(OutputStream out) throws IOException {
        if (this.interests == null || this.interests.isEmpty()) {
            return;
        }
        MinimalEncoder enc = new MinimalEncoder();
        enc.updateAll(this.interests);
        Tlv.getStringInstance(28, enc.getCharset()).write(out);
        for (String interest : this.interests) {
            byte[] interestBytes = enc.encode(interest).getData();
            new Tlv(11, (Writable)ByteBlock.wrap((byte[])interestBytes)).write(out);
        }
    }

    public String toString() {
        return "SetInterestsCmd: interests=" + this.interests;
    }
}

