/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;

class ReqOptSumScorer
extends Scorer {
    private Scorer reqScorer;
    private Scorer optScorer;

    public ReqOptSumScorer(Scorer reqScorer, Scorer optScorer) {
        super(null);
        this.reqScorer = reqScorer;
        this.optScorer = optScorer;
    }

    public boolean next() throws IOException {
        return this.reqScorer.next();
    }

    public int nextDoc() throws IOException {
        return this.reqScorer.nextDoc();
    }

    public boolean skipTo(int target) throws IOException {
        return this.reqScorer.skipTo(target);
    }

    public int advance(int target) throws IOException {
        return this.reqScorer.advance(target);
    }

    public int doc() {
        return this.reqScorer.doc();
    }

    public int docID() {
        return this.reqScorer.docID();
    }

    public float score() throws IOException {
        int curDoc = this.reqScorer.docID();
        float reqScore = this.reqScorer.score();
        if (this.optScorer == null) {
            return reqScore;
        }
        int optScorerDoc = this.optScorer.docID();
        if (optScorerDoc < curDoc && (optScorerDoc = this.optScorer.advance(curDoc)) == Integer.MAX_VALUE) {
            this.optScorer = null;
            return reqScore;
        }
        return optScorerDoc == curDoc ? reqScore + this.optScorer.score() : reqScore;
    }

    public Explanation explain(int doc) throws IOException {
        Explanation res = new Explanation();
        res.setDescription("required, optional");
        res.addDetail(this.reqScorer.explain(doc));
        res.addDetail(this.optScorer.explain(doc));
        return res;
    }
}

