/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapEntrySimple;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.operation.PartitionWideEntryBackupOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

public class PartitionWideEntryOperation
extends AbstractMapOperation
implements BackupAwareOperation,
PartitionAwareOperation {
    private static final EntryEventType __NO_NEED_TO_FIRE_EVENT = null;
    EntryProcessor entryProcessor;
    MapEntrySet response;

    public PartitionWideEntryOperation(String name, EntryProcessor entryProcessor) {
        super(name);
        this.entryProcessor = entryProcessor;
    }

    public PartitionWideEntryOperation() {
    }

    @Override
    public void innerBeforeRun() {
        ManagedContext managedContext = this.getNodeEngine().getSerializationService().getManagedContext();
        managedContext.initialize(this.entryProcessor);
    }

    @Override
    public void run() {
        this.response = new MapEntrySet();
        RecordStore recordStore = this.mapService.getRecordStore(this.getPartitionId(), this.name);
        Map<Data, Record> records = recordStore.getReadonlyRecordMap();
        for (Map.Entry<Data, Record> recordEntry : records.entrySet()) {
            Data dataKey = recordEntry.getKey();
            Record record = recordEntry.getValue();
            Object valueBeforeProcess = this.mapService.toObject(record.getValue());
            MapEntrySimple<Object, Object> entry = new MapEntrySimple<Object, Object>(this.mapService.toObject(record.getKey()), valueBeforeProcess);
            Object result = this.entryProcessor.process(entry);
            Object valueAfterProcess = entry.getValue();
            Data dataValue = null;
            if (result != null) {
                dataValue = this.mapService.toData(result);
                this.response.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(dataKey, dataValue));
            }
            EntryEventType eventType = null;
            if (valueAfterProcess == null) {
                recordStore.remove(dataKey);
                eventType = EntryEventType.REMOVED;
            } else {
                eventType = valueBeforeProcess == null ? EntryEventType.ADDED : (!entry.isModified() ? __NO_NEED_TO_FIRE_EVENT : EntryEventType.UPDATED);
                if (eventType != __NO_NEED_TO_FIRE_EVENT) {
                    recordStore.put(new AbstractMap.SimpleImmutableEntry<Data, Object>(dataKey, valueAfterProcess));
                }
            }
            if (eventType == __NO_NEED_TO_FIRE_EVENT) continue;
            this.mapService.publishEvent(this.getCallerAddress(), this.name, eventType, dataKey, this.mapService.toData(record.getValue()), dataValue);
            if (this.mapContainer.isNearCacheEnabled() && this.mapContainer.getMapConfig().getNearCacheConfig().isInvalidateOnChange()) {
                this.mapService.invalidateAllNearCaches(this.name, dataKey);
            }
            if (this.mapContainer.getWanReplicationPublisher() == null || this.mapContainer.getWanMergePolicy() == null) continue;
            if (EntryEventType.REMOVED.equals((Object)eventType)) {
                this.mapService.publishWanReplicationRemove(this.name, dataKey, Clock.currentTimeMillis());
                continue;
            }
            Record r = recordStore.getRecord(dataKey);
            SimpleEntryView<Data, Data> entryView = new SimpleEntryView<Data, Data>(dataKey, this.mapService.toData(dataValue), r.getStatistics(), r.getVersion());
            this.mapService.publishWanReplicationUpdate(this.name, entryView);
        }
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    public String toString() {
        return "PartitionWideEntryOperation{}";
    }

    @Override
    public boolean shouldBackup() {
        return this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getSyncBackupCount() {
        return 0;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getTotalBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return backupProcessor != null ? new PartitionWideEntryBackupOperation(this.name, backupProcessor) : null;
    }
}

