/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.configuration;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.File;
import net.java.sip.communicator.impl.configuration.JdbcConfigService;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.fileaccess.FileCategory;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ConfigurationActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(ConfigurationActivator.class);
    private ConfigurationService cs;

    public void start(BundleContext bundleContext) throws Exception {
        File useDatabaseConfig;
        FileAccessService fas = (FileAccessService)ServiceUtils.getService((BundleContext)bundleContext, FileAccessService.class);
        if (fas != null && (useDatabaseConfig = fas.getPrivatePersistentFile(".usedatabaseconfig", FileCategory.PROFILE)).exists()) {
            logger.info((Object)"Using database configuration store.");
            this.cs = new JdbcConfigService(fas);
        }
        if (this.cs == null) {
            this.cs = LibJitsi.getConfigurationService();
        }
        bundleContext.registerService(ConfigurationService.class.getName(), (Object)this.cs, null);
        ConfigurationActivator.fixPermissions(this.cs);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.cs.storeConfiguration();
        this.cs = null;
    }

    private static void fixPermissions(ConfigurationService configurationService) {
        if (!OSUtils.IS_LINUX && !OSUtils.IS_MAC) {
            return;
        }
        try {
            File cf;
            File homeFolder = new File(configurationService.getScHomeDirLocation(), configurationService.getScHomeDirName());
            CLibrary libc = (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);
            libc.chmod(homeFolder.getAbsolutePath(), 448);
            String fileName = configurationService.getConfigurationFilename();
            if (fileName != null && (cf = new File(homeFolder, fileName)).exists()) {
                libc.chmod(cf.getAbsolutePath(), 384);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error creating c lib instance for fixing file permissions", t);
        }
    }

    public static interface CLibrary
    extends Library {
        public int chmod(String var1, int var2);
    }
}

