/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.renderer.audio;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.MediaLocator;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.MacCoreAudioDevice;
import org.jitsi.impl.neomedia.device.MacCoreaudioSystem;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;
import org.jitsi.service.neomedia.BasicVolumeControl;

public class MacCoreaudioRenderer
extends AbstractAudioRenderer<MacCoreaudioSystem> {
    private String deviceUID = null;
    private long stream = 0L;
    private Object startStopMutex = new Object();
    private byte[] buffer = null;
    private int nbBufferData = 0;
    private boolean isStopping = false;
    private Lock stopLock = new ReentrantLock();
    private static final Format[] EMPTY_SUPPORTED_INPUT_FORMATS = new Format[0];
    private static final String PLUGIN_NAME = "MacCoreaudio Renderer";
    private static final Format[] SUPPORTED_INPUT_FORMATS;
    private static final double[] SUPPORTED_INPUT_SAMPLE_RATES;
    private final MacCoreaudioSystem.UpdateAvailableDeviceListListener updateAvailableDeviceListListener = new MacCoreaudioSystem.UpdateAvailableDeviceListListener(){
        private boolean start = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void didUpdateAvailableDeviceList() throws Exception {
            Object object = MacCoreaudioRenderer.this.startStopMutex;
            synchronized (object) {
                MacCoreaudioRenderer.this.updateDeviceUID();
                if (this.start) {
                    MacCoreaudioRenderer.this.open();
                    MacCoreaudioRenderer.this.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void willUpdateAvailableDeviceList() throws Exception {
            Object object = MacCoreaudioRenderer.this.startStopMutex;
            synchronized (object) {
                this.start = false;
                if (MacCoreaudioRenderer.this.stream != 0L) {
                    this.start = true;
                    MacCoreaudioRenderer.this.stop();
                }
            }
        }
    };
    private Format[] supportedInputFormats;

    public MacCoreaudioRenderer() {
        this(true);
    }

    public MacCoreaudioRenderer(boolean enableVolumeControl) {
        super("maccoreaudio", enableVolumeControl ? AudioSystem.DataFlow.PLAYBACK : AudioSystem.DataFlow.NOTIFY);
        MacCoreaudioSystem.addUpdateAvailableDeviceListListener(this.updateAvailableDeviceListListener);
    }

    @Override
    public void close() {
        this.stop();
        super.close();
    }

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public Format[] getSupportedInputFormats() {
        if (this.supportedInputFormats == null) {
            this.updateDeviceUID();
            if (this.deviceUID == null) {
                this.supportedInputFormats = SUPPORTED_INPUT_FORMATS;
            } else {
                int minOutputChannels = 1;
                int maxOutputChannels = Math.min(MacCoreAudioDevice.countOutputChannels(this.deviceUID), 2);
                ArrayList<Format> supportedInputFormats = new ArrayList<Format>(SUPPORTED_INPUT_FORMATS.length);
                for (Format supportedInputFormat : SUPPORTED_INPUT_FORMATS) {
                    this.getSupportedInputFormats(supportedInputFormat, minOutputChannels, maxOutputChannels, supportedInputFormats);
                }
                this.supportedInputFormats = supportedInputFormats.isEmpty() ? EMPTY_SUPPORTED_INPUT_FORMATS : supportedInputFormats.toArray(EMPTY_SUPPORTED_INPUT_FORMATS);
            }
        }
        return this.supportedInputFormats.length == 0 ? EMPTY_SUPPORTED_INPUT_FORMATS : (Format[])this.supportedInputFormats.clone();
    }

    private void getSupportedInputFormats(Format format, int minOutputChannels, int maxOutputChannels, List<Format> supportedInputFormats) {
        AudioFormat audioFormat = (AudioFormat)format;
        int sampleSizeInBits = audioFormat.getSampleSizeInBits();
        double sampleRate = audioFormat.getSampleRate();
        float minRate = MacCoreAudioDevice.getMinimalNominalSampleRate(this.deviceUID, true, MacCoreaudioSystem.isEchoCancelActivated());
        float maxRate = MacCoreAudioDevice.getMaximalNominalSampleRate(this.deviceUID, true, MacCoreaudioSystem.isEchoCancelActivated());
        for (int channels = minOutputChannels; channels <= maxOutputChannels; ++channels) {
            if (!(sampleRate >= (double)minRate) || !(sampleRate <= (double)maxRate)) continue;
            supportedInputFormats.add(new AudioFormat(audioFormat.getEncoding(), sampleRate, sampleSizeInBits, channels, audioFormat.getEndian(), audioFormat.getSigned(), -1, -1.0, audioFormat.getDataType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws ResourceUnavailableException {
        Object object = this.startStopMutex;
        synchronized (object) {
            if (this.stream == 0L) {
                MacCoreaudioSystem.willOpenStream();
                try {
                    if (!this.updateDeviceUID()) {
                        throw new ResourceUnavailableException("No locator/MediaLocator is set.");
                    }
                    if (this.inputFormat == null) {
                        throw new ResourceUnavailableException("inputFormat not set");
                    }
                }
                finally {
                    MacCoreaudioSystem.didOpenStream();
                }
            }
            super.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void playbackDevicePropertyChange(PropertyChangeEvent ev) {
        Object object = this.startStopMutex;
        synchronized (object) {
            this.stop();
            this.updateDeviceUID();
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int process(Buffer buffer) {
        Object object = this.startStopMutex;
        synchronized (object) {
            if (this.stream != 0L && !this.isStopping) {
                GainControl gainControl = this.getGainControl();
                if (gainControl != null) {
                    BasicVolumeControl.applyGain(gainControl, (byte[])buffer.getData(), buffer.getOffset(), buffer.getLength());
                }
                int length = buffer.getLength();
                int timeout = 2000;
                int maxNbBuffers = timeout / 20;
                this.updateBufferLength(Math.min(this.nbBufferData + length, length * maxNbBuffers));
                if (this.nbBufferData + length > this.buffer.length) {
                    length = this.buffer.length - this.nbBufferData;
                }
                System.arraycopy((byte[])buffer.getData(), buffer.getOffset(), this.buffer, this.nbBufferData, length);
                this.nbBufferData += length;
            }
        }
        return 0;
    }

    @Override
    public void setLocator(MediaLocator locator) {
        super.setLocator(locator);
        this.updateDeviceUID();
        this.supportedInputFormats = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.startStopMutex;
        synchronized (object) {
            if (this.stream == 0L && this.deviceUID != null) {
                int nbChannels = ((AudioFormat)this.inputFormat).getChannels();
                if (nbChannels == -1) {
                    nbChannels = 1;
                }
                MacCoreaudioSystem.willOpenStream();
                this.stream = MacCoreAudioDevice.startStream(this.deviceUID, this, (float)((AudioFormat)this.inputFormat).getSampleRate(), nbChannels, ((AudioFormat)this.inputFormat).getSampleSizeInBits(), false, ((AudioFormat)this.inputFormat).getEndian() == 1, false, false, MacCoreaudioSystem.isEchoCancelActivated());
                MacCoreaudioSystem.didOpenStream();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        boolean doStop = false;
        Object object = this.startStopMutex;
        synchronized (object) {
            if (this.stream != 0L && this.deviceUID != null && !this.isStopping) {
                long startTime;
                doStop = true;
                this.isStopping = true;
                long timeout = 500L;
                long currentTime = startTime = System.currentTimeMillis();
                while (this.nbBufferData > 0 && currentTime - startTime < timeout) {
                    try {
                        this.startStopMutex.wait(timeout);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    currentTime = System.currentTimeMillis();
                }
            }
        }
        if (doStop) {
            this.stopLock.lock();
            try {
                object = this.startStopMutex;
                synchronized (object) {
                    if (this.stream != 0L && this.deviceUID != null) {
                        MacCoreAudioDevice.stopStream(this.deviceUID, this.stream);
                        this.stream = 0L;
                        this.buffer = null;
                        this.nbBufferData = 0;
                        this.isStopping = false;
                    }
                }
            }
            finally {
                this.stopLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOutput(byte[] buffer, int bufferLength) {
        if (this.stopLock.tryLock()) {
            try {
                Object object = this.startStopMutex;
                synchronized (object) {
                    this.updateBufferLength(bufferLength);
                    int length = this.nbBufferData;
                    if (bufferLength < length) {
                        length = bufferLength;
                    }
                    System.arraycopy(this.buffer, 0, buffer, 0, length);
                    if (length < bufferLength) {
                        Arrays.fill(buffer, length, bufferLength, (byte)0);
                    }
                    this.nbBufferData -= length;
                    if (this.nbBufferData > 0) {
                        System.arraycopy(this.buffer, length, this.buffer, 0, this.nbBufferData);
                    } else {
                        this.startStopMutex.notify();
                    }
                }
            }
            finally {
                this.stopLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDeviceUID() {
        String remainder;
        MediaLocator locator = this.getLocator();
        if (locator != null && (remainder = locator.getRemainder()) != null && remainder.length() > 1) {
            Object object = this.startStopMutex;
            synchronized (object) {
                this.deviceUID = remainder.substring(1);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBufferLength(int newLength) {
        Object object = this.startStopMutex;
        synchronized (object) {
            if (this.buffer == null) {
                this.buffer = new byte[newLength];
                this.nbBufferData = 0;
            } else if (newLength > this.buffer.length) {
                byte[] newBuffer = new byte[newLength];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.nbBufferData);
                this.buffer = newBuffer;
            }
        }
    }

    static {
        SUPPORTED_INPUT_SAMPLE_RATES = new double[]{8000.0, 11025.0, 16000.0, 22050.0, 32000.0, 44100.0, 48000.0};
        int count = SUPPORTED_INPUT_SAMPLE_RATES.length;
        SUPPORTED_INPUT_FORMATS = new Format[count];
        for (int i = 0; i < count; ++i) {
            MacCoreaudioRenderer.SUPPORTED_INPUT_FORMATS[i] = new AudioFormat("LINEAR", SUPPORTED_INPUT_SAMPLE_RATES[i], 16, -1, 0, 1, -1, -1.0, Format.byteArray);
        }
    }
}

